/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameModelingVisitor;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Iterator;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class TaintAnalysis
extends FrameDataflowAnalysis<Taint, TaintFrame> {
    private final MethodGen methodGen;
    private final MethodDescriptor methodDescriptor;
    private final TaintFrameModelingVisitor visitor;
    private final int parameterStackSize;

    public TaintAnalysis(MethodGen methodGen, DepthFirstSearch dfs, MethodDescriptor descriptor, TaintMethodSummaryMap methodSummaries) {
        super(dfs);
        this.methodGen = methodGen;
        this.methodDescriptor = descriptor;
        this.visitor = new TaintFrameModelingVisitor(methodGen.getConstantPool(), descriptor, methodSummaries);
        this.parameterStackSize = TaintAnalysis.getParameterStackSize(descriptor.getSignature(), descriptor.isStatic());
    }

    protected void mergeValues(TaintFrame frame, TaintFrame result, int i) throws DataflowAnalysisException {
        result.setValue(i, Taint.merge((Taint)result.getValue(i), (Taint)frame.getValue(i)));
    }

    public void transferInstruction(InstructionHandle handle, BasicBlock block, TaintFrame fact) throws DataflowAnalysisException {
        this.visitor.setFrameAndLocation(fact, new Location(handle, block));
        this.visitor.analyzeInstruction(handle.getInstruction());
    }

    public TaintFrame createFact() {
        return new TaintFrame(this.methodGen.getMaxLocals());
    }

    public void initEntryFact(TaintFrame fact) throws DataflowAnalysisException {
        fact.setValid();
        fact.clearStack();
        boolean inMainMethod = this.isInMainMethod();
        int numSlots = fact.getNumSlots();
        int numLocals = fact.getNumLocals();
        for (int i = 0; i < numSlots; ++i) {
            Taint value = inMainMethod ? new Taint(Taint.State.TAINTED) : new Taint(Taint.State.UNKNOWN);
            if (i < numLocals) {
                value.setVariableIndex(i);
                if (i < this.parameterStackSize && !inMainMethod) {
                    int stackOffset = this.parameterStackSize - i - 1;
                    value.addParameter(stackOffset);
                }
            }
            fact.setValue(i, value);
        }
    }

    private boolean isInMainMethod() {
        return this.methodDescriptor.isStatic() && "main".equals(this.methodDescriptor.getName()) && "([Ljava/lang/String;)V".equals(this.methodDescriptor.getSignature()) && this.methodGen.getMethod().isPublic();
    }

    public void meetInto(TaintFrame fact, Edge edge, TaintFrame result) throws DataflowAnalysisException {
        if (fact.isValid() && edge.isExceptionEdge()) {
            TaintFrame copy = null;
            copy = (TaintFrame)this.modifyFrame(fact, copy);
            copy.clearStack();
            copy.pushValue(new Taint(Taint.State.UNKNOWN));
            fact = copy;
        }
        this.mergeInto(fact, result);
    }

    public void finishAnalysis() {
        this.visitor.finishAnalysis();
    }

    private static int getParameterStackSize(String signature, boolean isStatic) {
        assert (signature != null && !signature.isEmpty());
        int stackSize = isStatic ? 0 : 1;
        GenericSignatureParser parser = new GenericSignatureParser(signature);
        Iterator iterator = parser.parameterSignatureIterator();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (parameter.equals("D") || parameter.equals("J")) {
                stackSize += 2;
                continue;
            }
            ++stackSize;
        }
        return stackSize;
    }
}

