/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.TreeSet;

public class TaintMethodSummaryMap
extends HashMap<String, TaintMethodSummary> {
    private static final long serialVersionUID = 1L;

    public void load(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            this.putFromLine(line);
        }
    }

    public void dump(PrintStream output) {
        TreeSet keys = new TreeSet(this.keySet());
        for (String key : keys) {
            output.println(key + ":" + this.get(key));
        }
    }

    private void putFromLine(String line) throws IOException {
        if (line.startsWith("-")) {
            return;
        }
        String[] tuple = line.split("\\:");
        if (tuple.length != 2) {
            throw new IOException("Line format is not 'method name:summary info'");
        }
        this.put(tuple[0].trim(), TaintMethodSummary.load(tuple[1]));
    }
}

