/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.StackUtils;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class ReDosDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = true;
    private static final String REDOS_TYPE = "REDOS";
    private static final char[] OPENING_CHAR = new char[]{'(', '['};
    private static final char[] CLOSING_CHAR = new char[]{')', ']'};
    private static final char[] PLUS_CHAR = new char[]{'+', '*', '?'};
    private static final InvokeMatcherBuilder PATTERN_COMPILE = InstructionDSL.invokeInstruction().atClass("java/util/regex/Pattern").atMethod("compile").withArgs("(Ljava/lang/String;)Ljava/util/regex/Pattern;");
    private static final InvokeMatcherBuilder STRING_MATCHES = InstructionDSL.invokeInstruction().atClass("java/lang/String").atMethod("matches").withArgs("(Ljava/lang/String;)Z");
    private BugReporter bugReporter;

    public ReDosDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if (seen == 184 && PATTERN_COMPILE.matches(this)) {
            OpcodeStack.Item item2 = this.stack.getStackItem(0);
            if (!StackUtils.isVariableString(item2)) {
                String value = (String)item2.getConstant();
                this.analyseRegexString(value);
            }
        } else if (seen == 182 && STRING_MATCHES.matches(this) && !StackUtils.isVariableString(item = this.stack.getStackItem(0))) {
            String value = (String)item.getConstant();
            this.analyseRegexString(value);
        }
    }

    public void analyseRegexString(String regex) {
        if (regex.length() > 0) {
            this.recurAnalyseRegex(regex, regex.length() - 1, 0);
        }
    }

    private int recurAnalyseRegex(String regex, int startPosition, int level) {
        if (level == 2) {
            MethodDescriptor md = this.getMethodDescriptor();
            FieldDescriptor fd = this.getFieldDescriptor();
            BugInstance bug = new BugInstance((Detector)this, REDOS_TYPE, 2).addString(regex).addClass((PreorderVisitor)this);
            if (md != null) {
                bug.addMethod(md);
            }
            if (fd != null) {
                bug.addField(fd);
            }
            try {
                bug.addSourceLine((BytecodeScanningDetector)this);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            this.bugReporter.reportBug(bug);
            return 0;
        }
        boolean openingMode = false;
        for (int i = startPosition; i >= 0; --i) {
            if (this.isChar(regex, i, OPENING_CHAR)) {
                return i;
            }
            if (!this.isChar(regex, i, CLOSING_CHAR)) continue;
            int newLevel = level;
            if (i + 1 < regex.length() && this.isChar(regex, i + 1, PLUS_CHAR)) {
                ++newLevel;
            }
            openingMode = true;
            if ((i = this.recurAnalyseRegex(regex, i - 1, newLevel)) != -1) continue;
            return 0;
        }
        return 0;
    }

    private boolean isChar(String value, int position, char[] charToTest) {
        char actualChar = value.charAt(position);
        boolean oneCharFound = false;
        for (char ch : charToTest) {
            if (actualChar != ch) continue;
            oneCharFound = true;
            break;
        }
        return oneCharFound && (position == 0 || value.charAt(position - 1) != '\\');
    }
}

