/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.cookie;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;

public class CookieFlagsDetector
implements Detector {
    private static final String INSECURE_COOKIE_TYPE = "INSECURE_COOKIE";
    private static final String HTTPONLY_COOKIE_TYPE = "HTTPONLY_COOKIE";
    private BugReporter bugReporter;
    private static final int TRUE_INT_VALUE = 1;

    public CookieFlagsDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException e) {
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        JavaClass clz;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        boolean newCookieCreated = false;
        boolean secureCookieIsSet = false;
        boolean httpOnlyCookieIsSet = false;
        ArrayList<Location> cookieLocations = new ArrayList<Location>();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Integer val;
            INVOKESPECIAL invoke;
            Location loc = (Location)i.next();
            Instruction inst = loc.getHandle().getInstruction();
            if (inst instanceof INVOKESPECIAL) {
                invoke = (INVOKESPECIAL)inst;
                if (!"javax.servlet.http.Cookie".equals(invoke.getClassName(cpg)) || !"<init>".equals(invoke.getMethodName(cpg))) continue;
                newCookieCreated = true;
                cookieLocations.add(loc);
                continue;
            }
            if (!(inst instanceof INVOKEVIRTUAL)) continue;
            invoke = (INVOKEVIRTUAL)inst;
            if ("javax.servlet.http.Cookie".equals(invoke.getClassName(cpg)) && "setSecure".equals(invoke.getMethodName(cpg)) && (val = ByteCode.getConstantInt(loc.getHandle().getPrev())) != null && val == 1) {
                secureCookieIsSet = true;
            }
            if (!"javax.servlet.http.Cookie".equals(invoke.getClassName(cpg)) || !"setHttpOnly".equals(invoke.getMethodName(cpg)) || (val = ByteCode.getConstantInt(loc.getHandle().getPrev())) == null || val != 1) continue;
            httpOnlyCookieIsSet = true;
        }
        if (newCookieCreated && !secureCookieIsSet) {
            clz = classContext.getJavaClass();
            for (Location loc : cookieLocations) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, INSECURE_COOKIE_TYPE, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, loc));
            }
        }
        if (newCookieCreated && !httpOnlyCookieIsSet) {
            clz = classContext.getJavaClass();
            for (Location loc : cookieLocations) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, HTTPONLY_COOKIE_TYPE, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, loc));
            }
        }
    }

    public void report() {
    }
}

