/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.AbstractTaintDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintLocation;
import com.h3xstream.findsecbugs.taintanalysis.TaintSink;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class AbstractInjectionDetector
extends AbstractTaintDetector {
    protected final Map<String, Set<TaintSink>> methodsWithSinks = new HashMap<String, Set<TaintSink>>();

    protected AbstractInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void report() {
        HashSet<BugInstance> bugs = new HashSet<BugInstance>();
        for (Set<TaintSink> sinkSet : this.methodsWithSinks.values()) {
            for (TaintSink sink : sinkSet) {
                bugs.add(sink.getBugInstance());
            }
        }
        for (BugInstance bug : bugs) {
            this.bugReporter.reportBug(bug);
        }
    }

    @Override
    protected void analyzeLocation(ClassContext classContext, Method method, InstructionHandle handle, ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame fact, String currentMethod) throws DataflowAnalysisException {
        SourceLineAnnotation sourceLine = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (Method)method, (InstructionHandle)handle);
        this.checkTaintSink(cpg, invoke, fact, sourceLine, currentMethod);
        InjectionPoint injectionPoint = this.getInjectionPoint(invoke, cpg, handle);
        for (int offset : injectionPoint.getInjectableArguments()) {
            Taint parameterTaint = (Taint)fact.getStackValue(offset);
            int priority = this.getPriority(parameterTaint);
            if (priority == 5) continue;
            BugInstance bugInstance = new BugInstance((Detector)this, injectionPoint.getBugType(), priority);
            bugInstance.addClassAndMethod(classContext.getJavaClass(), method);
            bugInstance.addSourceLine(sourceLine);
            if (injectionPoint.getInjectableMethod() != null) {
                bugInstance.addString(injectionPoint.getInjectableMethod());
            }
            this.reportBug(bugInstance, parameterTaint, currentMethod);
            return;
        }
    }

    protected int getPriority(Taint taint) {
        if (taint.isTainted()) {
            return 1;
        }
        if (!taint.isSafe()) {
            return 2;
        }
        return 5;
    }

    private void checkTaintSink(ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame fact, SourceLineAnnotation sourceLine, String currentMethod) throws DataflowAnalysisException {
        for (TaintSink sink : this.getSinks(cpg, invoke, fact)) {
            Taint sinkTaint = sink.getTaint();
            Set<Integer> taintParameters = sinkTaint.getParameters();
            Taint finalTaint = Taint.valueOf(sinkTaint.getNonParametricState());
            for (Integer offset : taintParameters) {
                Taint parameterTaint = (Taint)fact.getStackValue(offset);
                finalTaint = Taint.merge(finalTaint, parameterTaint);
            }
            if (finalTaint == null || !finalTaint.isTainted() && !finalTaint.hasParameters()) continue;
            BugInstance bugInstance = sink.getBugInstance();
            bugInstance.addSourceLine(sourceLine);
            AbstractInjectionDetector.addSourceLines(finalTaint.getLocations(), bugInstance);
            if (finalTaint.isTainted()) {
                bugInstance.setPriority(this.getPriority(finalTaint));
                continue;
            }
            assert (finalTaint.isUnknown());
            this.delayBugToReport(currentMethod, finalTaint, bugInstance);
        }
    }

    private Set<TaintSink> getSinks(ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame frame) {
        String methodName;
        String className = AbstractInjectionDetector.getInstanceClassName(cpg, invoke, frame);
        Set<TaintSink> sinks = this.methodsWithSinks.get(className.concat(methodName = "." + invoke.getMethodName(cpg) + invoke.getSignature(cpg)));
        if (sinks != null) {
            return sinks;
        }
        try {
            JavaClass javaClass = Repository.lookupClass((String)className);
            assert (javaClass != null);
            return this.getSuperSinks(javaClass, methodName);
        }
        catch (ClassNotFoundException ex) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
            return Collections.emptySet();
        }
    }

    private Set<TaintSink> getSuperSinks(JavaClass javaClass, String method) throws ClassNotFoundException {
        Set<TaintSink> sinks;
        String fullMethodName;
        for (JavaClass superClass : javaClass.getSuperClasses()) {
            fullMethodName = superClass.getClassName().replace('.', '/').concat(method);
            sinks = this.methodsWithSinks.get(fullMethodName);
            if (sinks == null) continue;
            return sinks;
        }
        for (JavaClass interfaceClass : javaClass.getAllInterfaces()) {
            fullMethodName = interfaceClass.getClassName().replace('.', '/').concat(method);
            sinks = this.methodsWithSinks.get(fullMethodName);
            if (sinks == null) continue;
            return sinks;
        }
        return Collections.emptySet();
    }

    private void reportBug(BugInstance bugInstance, Taint taint, String currentMethod) {
        AbstractInjectionDetector.addSourceLines(taint.getLocations(), bugInstance);
        if (this.shouldBugBeDelayed(taint, bugInstance)) {
            this.delayBugToReport(currentMethod, taint, bugInstance);
        } else {
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private boolean shouldBugBeDelayed(Taint taint, BugInstance bugInstance) {
        if (!taint.hasParameters()) {
            return false;
        }
        return bugInstance.getPriority() == this.getPriority(new Taint(Taint.State.UNKNOWN));
    }

    private void delayBugToReport(String method, Taint taint, BugInstance bug) {
        TaintSink taintSink = new TaintSink(taint, bug);
        Set<TaintSink> sinkSet = this.methodsWithSinks.get(method);
        if (sinkSet == null) {
            sinkSet = new HashSet<TaintSink>();
        }
        sinkSet.add(taintSink);
        this.methodsWithSinks.put(method, sinkSet);
    }

    private static void addSourceLines(Collection<TaintLocation> locations, BugInstance bugInstance) {
        LinkedList<SourceLineAnnotation> annotations = new LinkedList<SourceLineAnnotation>();
        for (TaintLocation location : locations) {
            SourceLineAnnotation taintSource = SourceLineAnnotation.fromVisitedInstruction((MethodDescriptor)location.getMethodDescriptor(), (int)location.getPosition());
            annotations.add(taintSource);
        }
        Collections.sort(annotations);
        SourceLineAnnotation annotation = null;
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            SourceLineAnnotation prev = annotation;
            annotation = (SourceLineAnnotation)it.next();
            if (prev == null || !prev.getClassName().equals(annotation.getClassName()) || prev.getStartLine() != annotation.getStartLine()) continue;
            it.remove();
        }
        for (SourceLineAnnotation sourceLine : annotations) {
            bugInstance.addSourceLine(sourceLine);
        }
    }

    private static String getInstanceClassName(ConstantPoolGen cpg, InvokeInstruction invoke, TaintFrame frame) {
        block5: {
            try {
                int instanceIndex = frame.getNumArgumentsIncludingObjectInstance(invoke, cpg) - 1;
                if (instanceIndex != -1) {
                    assert (instanceIndex < frame.getStackDepth());
                    Taint instanceTaint = (Taint)frame.getStackValue(instanceIndex);
                    String className = instanceTaint.getRealInstanceClassName();
                    if (className != null) {
                        return className;
                    }
                }
            }
            catch (DataflowAnalysisException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        String dottedClassName = invoke.getReferenceType(cpg).toString();
        return ClassName.toSlashedClassName((String)dottedClassName);
    }

    protected abstract InjectionPoint getInjectionPoint(InvokeInstruction var1, ConstantPoolGen var2, InstructionHandle var3);
}

