/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintAnalysis;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.bcel.generic.MethodGen;

public class TaintDataflowEngine
implements IMethodAnalysisEngine<TaintDataflow> {
    private static final String METHODS_SUMMARIES_PATH = "taint-config/";
    private static final String[] METHODS_SUMMARIES_FILENAMES = new String[]{"java-lang.txt", "java-ee.txt", "collections.txt", "java-net.txt", "scala.txt", "other.txt"};
    private static final String SAFE_ENCODERS_PATH = "safe-encoders/";
    private static final String[] SAFE_ENCODERS_FILENAMES = new String[]{"xss-encoders.txt"};
    private final TaintMethodSummaryMap methodSummaries = new TaintMethodSummaryMap();
    private static Writer writer = null;

    public TaintDataflowEngine() {
        for (String path : METHODS_SUMMARIES_FILENAMES) {
            this.loadMethodSummaries(METHODS_SUMMARIES_PATH.concat(path));
        }
        for (String path : SAFE_ENCODERS_FILENAMES) {
            this.loadMethodSummaries(SAFE_ENCODERS_PATH.concat(path));
        }
    }

    private void loadMethodSummaries(String path) {
        assert (path != null && !path.isEmpty());
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(path);
            this.methodSummaries.load(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot load summaries from " + path, ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException("cannot close stream", ex);
                }
            }
        }
    }

    public TaintDataflow analyze(IAnalysisCache cache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        TaintMethodSummary derivedSummary;
        CFG cfg = (CFG)cache.getMethodAnalysis(CFG.class, descriptor);
        DepthFirstSearch dfs = (DepthFirstSearch)cache.getMethodAnalysis(DepthFirstSearch.class, descriptor);
        MethodGen methodGen = (MethodGen)cache.getMethodAnalysis(MethodGen.class, descriptor);
        TaintAnalysis analysis = new TaintAnalysis(methodGen, dfs, descriptor, this.methodSummaries);
        TaintDataflow flow = new TaintDataflow(cfg, analysis);
        flow.execute();
        analysis.finishAnalysis();
        if (FindSecBugsGlobalConfig.getInstance().isDebugOutputSummaries() && writer != null && (derivedSummary = (TaintMethodSummary)this.methodSummaries.get(TaintDataflowEngine.getSlashedMethodName(methodGen))) != null) {
            try {
                writer.append(TaintDataflowEngine.getSlashedMethodName(methodGen) + ":" + derivedSummary + "\n");
                writer.flush();
            }
            catch (IOException ex) {
                System.out.println("cannot write: " + ex.getMessage());
            }
        }
        return flow;
    }

    private static String getSlashedMethodName(MethodGen methodGen) {
        String methodNameWithSignature = methodGen.getName() + methodGen.getSignature();
        String slashedClassName = methodGen.getClassName().replace('.', '/');
        return slashedClassName + "." + methodNameWithSignature;
    }

    public void registerWith(IAnalysisCache iac) {
        iac.registerMethodAnalysisEngine(TaintDataflow.class, (IMethodAnalysisEngine)this);
    }

    static {
        if (FindSecBugsGlobalConfig.getInstance().isDebugOutputSummaries()) {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("derived-summaries.txt"), "utf-8"));
            }
            catch (UnsupportedEncodingException ex) {
                assert (false) : ex.getMessage();
            }
            catch (FileNotFoundException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

