/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintLocation;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.StoreInstruction;

public class TaintFrameModelingVisitor
extends AbstractFrameModelingVisitor<Taint, TaintFrame> {
    private static final Set<String> SAFE_OBJECT_TYPES = new HashSet<String>(9);
    private static final Set<String> IMMUTABLE_OBJECT_TYPES;
    private final MethodDescriptor methodDescriptor;
    private final TaintMethodSummaryMap methodSummaries;
    private final TaintMethodSummary analyzedMethodSummary;

    public TaintFrameModelingVisitor(ConstantPoolGen cpg, MethodDescriptor method, TaintMethodSummaryMap methodSummaries) {
        super(cpg);
        if (method == null) {
            throw new NullPointerException("null method descriptor");
        }
        if (methodSummaries == null) {
            throw new NullPointerException("null method summaries");
        }
        this.methodDescriptor = method;
        this.methodSummaries = methodSummaries;
        this.analyzedMethodSummary = new TaintMethodSummary(false);
    }

    private static Collection<Integer> getMutableStackIndices(String signature) {
        assert (signature != null && !signature.isEmpty());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int stackIndex = 0;
        GenericSignatureParser parser = new GenericSignatureParser(signature);
        Iterator iterator = parser.parameterSignatureIterator();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if ((parameter.startsWith("L") || parameter.startsWith("[")) && !IMMUTABLE_OBJECT_TYPES.contains(parameter)) {
                indices.add(stackIndex);
            }
            if (parameter.equals("D") || parameter.equals("J")) {
                stackIndex += 2;
                continue;
            }
            ++stackIndex;
        }
        for (int i = 0; i < indices.size(); ++i) {
            int reverseIndex = stackIndex - indices.get(i) - 1;
            assert (reverseIndex >= 0);
            indices.set(i, reverseIndex);
        }
        return indices;
    }

    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        if (FindSecBugsGlobalConfig.getInstance().isDebugPrintInvocationVisited() && ins instanceof InvokeInstruction) {
            ByteCode.printOpCode(ins, this.cpg);
        } else if (FindSecBugsGlobalConfig.getInstance().isDebugPrintInstructionVisited()) {
            ByteCode.printOpCode(ins, this.cpg);
        }
        super.analyzeInstruction(ins);
    }

    public Taint getDefaultValue() {
        return new Taint(Taint.State.UNKNOWN);
    }

    public void visitLDC(LDC ldc) {
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            Object value = ldc.getValue(this.cpg);
            if (value instanceof String) {
                this.pushSafeDebug("\"" + value + "\"");
            } else {
                this.pushSafeDebug("LDC " + ldc.getType(this.cpg).getSignature());
            }
        } else {
            this.pushSafe();
        }
    }

    public void visitLDC2_W(LDC2_W obj) {
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            this.pushSafeDebug("partial long/double");
            this.pushSafeDebug("partial long/double");
        } else {
            this.pushSafe();
            this.pushSafe();
        }
    }

    public void visitACONST_NULL(ACONST_NULL obj) {
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL).setDebugInfo("NULL"));
        } else {
            ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL));
        }
    }

    public void visitICONST(ICONST obj) {
        Taint t = new Taint(Taint.State.SAFE);
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            t.setDebugInfo("" + obj.getValue().intValue());
        }
        ((TaintFrame)this.getFrame()).pushValue(t);
    }

    public void visitGETFIELD(GETFIELD obj) {
        super.visitGETFIELD(obj);
    }

    public void visitNEW(NEW obj) {
        Taint taint = new Taint(Taint.State.SAFE);
        ObjectType type = obj.getLoadClassType(this.cpg);
        taint.setRealInstanceClass(type);
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            taint.setDebugInfo("new " + type.getClassName() + "()");
        }
        ((TaintFrame)this.getFrame()).pushValue(taint);
    }

    public void handleStoreInstruction(StoreInstruction obj) {
        try {
            int numConsumed = obj.consumeStack(this.cpg);
            if (numConsumed == -2) {
                throw new InvalidBytecodeException("Unpredictable stack consumption");
            }
            int index = obj.getIndex();
            while (numConsumed-- > 0) {
                Taint value = new Taint((Taint)((TaintFrame)this.getFrame()).popValue());
                value.setVariableIndex(index);
                ((TaintFrame)this.getFrame()).setValue(index++, value);
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException(ex.toString(), (Throwable)ex);
        }
    }

    public void handleLoadInstruction(LoadInstruction obj) {
        int numProduced = obj.produceStack(this.cpg);
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        int index = obj.getIndex() + numProduced;
        while (numProduced-- > 0) {
            Taint value = (Taint)((TaintFrame)this.getFrame()).getValue(--index);
            assert (value.hasValidVariableIndex()) : "index not set in " + this.methodDescriptor;
            assert (index == value.getVariableIndex()) : "bad index in " + this.methodDescriptor;
            ((TaintFrame)this.getFrame()).pushValue(new Taint(value));
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitANEWARRAY(ANEWARRAY obj) {
        try {
            ((TaintFrame)this.getFrame()).popValue();
            if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
                this.pushSafeDebug("new " + obj.getLoadClassType(this.cpg).getClassName() + "[]");
            } else {
                this.pushSafe();
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Array length not in the stack", (Throwable)ex);
        }
    }

    public void visitAASTORE(AASTORE obj) {
        try {
            Taint valueTaint = (Taint)((TaintFrame)this.getFrame()).popValue();
            ((TaintFrame)this.getFrame()).popValue();
            Taint arrayTaint = (Taint)((TaintFrame)this.getFrame()).popValue();
            Taint merge = Taint.merge(valueTaint, arrayTaint);
            this.setLocalVariableTaint(merge, arrayTaint);
            Taint stackTop = null;
            if (((TaintFrame)this.getFrame()).getStackDepth() > 0) {
                stackTop = (Taint)((TaintFrame)this.getFrame()).getTopValue();
            }
            if (stackTop == arrayTaint) {
                ((TaintFrame)this.getFrame()).popValue();
                ((TaintFrame)this.getFrame()).pushValue(new Taint(merge));
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
        }
    }

    public void visitAALOAD(AALOAD obj) {
        try {
            ((TaintFrame)this.getFrame()).popValue();
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
        }
    }

    public void visitCHECKCAST(CHECKCAST obj) {
    }

    public void visitARETURN(ARETURN obj) {
        try {
            Taint returnTaint = (Taint)((TaintFrame)this.getFrame()).getTopValue();
            Taint currentTaint = this.analyzedMethodSummary.getOutputTaint();
            this.analyzedMethodSummary.setOuputTaint(Taint.merge(returnTaint, currentTaint));
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("empty stack before reference return", (Throwable)ex);
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    private void visitInvoke(InvokeInstruction obj) {
        assert (obj != null);
        TaintMethodSummary methodSummary = this.getMethodSummary(obj);
        ObjectType realInstanceClass = methodSummary == null ? null : methodSummary.getOutputTaint().getRealInstanceClass();
        Taint taint = this.getMethodTaint(methodSummary);
        assert (taint != null);
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            taint.setDebugInfo(obj.getMethodName(this.cpg) + "()");
        }
        if (taint.isUnknown()) {
            taint.addLocation(this.getTaintLocation(), false);
        }
        this.taintMutableArguments(methodSummary, obj);
        this.transferTaintToMutables(methodSummary, taint);
        Taint taintCopy = new Taint(taint);
        taintCopy.setRealInstanceClass(realInstanceClass);
        this.modelInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), this.getNumWordsProduced((Instruction)obj), taintCopy);
    }

    private TaintMethodSummary getMethodSummary(InvokeInstruction obj) {
        String signature = obj.getSignature(this.cpg);
        String returnType = TaintFrameModelingVisitor.getReturnType(signature);
        if (SAFE_OBJECT_TYPES.contains(returnType)) {
            return TaintMethodSummary.SAFE_SUMMARY;
        }
        String className = this.getInstanceClassName(obj);
        String methodName = obj.getMethodName(this.cpg);
        String methodId = "." + methodName + signature;
        TaintMethodSummary summary = (TaintMethodSummary)this.methodSummaries.get(className.concat(methodId));
        if (summary != null) {
            return summary;
        }
        summary = this.getSuperMethodSummary(className, methodId);
        if (summary != null) {
            return summary;
        }
        if ("<init>".equals(methodName) && !SAFE_OBJECT_TYPES.contains("L" + className + ";")) {
            try {
                int stackSize = ((TaintFrame)this.getFrame()).getNumArgumentsIncludingObjectInstance(obj, this.cpg);
                return TaintMethodSummary.getDefaultConstructorSummary(stackSize);
            }
            catch (DataflowAnalysisException ex) {
                throw new InvalidBytecodeException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private String getInstanceClassName(InvokeInstruction invoke) {
        block5: {
            try {
                int instanceIndex = ((TaintFrame)this.getFrame()).getNumArgumentsIncludingObjectInstance(invoke, this.cpg) - 1;
                if (instanceIndex != -1) {
                    assert (instanceIndex < ((TaintFrame)this.getFrame()).getStackDepth());
                    Taint instanceTaint = (Taint)((TaintFrame)this.getFrame()).getStackValue(instanceIndex);
                    String className = instanceTaint.getRealInstanceClassName();
                    if (className != null) {
                        return className;
                    }
                }
            }
            catch (DataflowAnalysisException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        String dottedClassName = invoke.getReferenceType(this.cpg).toString();
        return ClassName.toSlashedClassName((String)dottedClassName);
    }

    private TaintMethodSummary getSuperMethodSummary(String className, String methodId) {
        try {
            JavaClass javaClass = Repository.lookupClass((String)className);
            assert (javaClass != null);
            TaintMethodSummary summary = this.getSuperMethodSummary(javaClass.getSuperClasses(), methodId);
            if (summary != null) {
                return summary;
            }
            return this.getSuperMethodSummary(javaClass.getAllInterfaces(), methodId);
        }
        catch (ClassNotFoundException ex) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
            return null;
        }
    }

    private TaintMethodSummary getSuperMethodSummary(JavaClass[] javaClasses, String method) {
        assert (javaClasses != null);
        for (JavaClass classOrInterface : javaClasses) {
            String fullMethodName = classOrInterface.getClassName().replace('.', '/').concat(method);
            TaintMethodSummary summary = (TaintMethodSummary)this.methodSummaries.get(fullMethodName);
            if (summary == null) continue;
            return summary;
        }
        return null;
    }

    private static String getReturnType(String signature) {
        assert (signature != null && signature.contains(")"));
        return signature.substring(signature.indexOf(41) + 1);
    }

    private Taint getMethodTaint(TaintMethodSummary methodSummary) {
        if (methodSummary == null) {
            return this.getDefaultValue();
        }
        Taint taint = methodSummary.getOutputTaint();
        assert (taint != null);
        assert (taint != methodSummary.getOutputTaint()) : "defensive copy not made";
        if (taint.isUnknown() && taint.hasParameters()) {
            Taint merge = this.mergeTransferParameters(taint.getParameters());
            assert (merge != null);
            return Taint.merge(Taint.valueOf(taint.getNonParametricState()), merge);
        }
        if (taint.isTainted()) {
            taint.addLocation(this.getTaintLocation(), true);
        }
        return taint;
    }

    private void taintMutableArguments(TaintMethodSummary methodSummary, InvokeInstruction obj) {
        if (methodSummary != null && methodSummary.isConfigured()) {
            return;
        }
        Collection<Integer> mutableStackIndices = TaintFrameModelingVisitor.getMutableStackIndices(obj.getSignature(this.cpg));
        for (Integer index : mutableStackIndices) {
            assert (index >= 0 && index < ((TaintFrame)this.getFrame()).getStackDepth());
            try {
                Taint stackValue = (Taint)((TaintFrame)this.getFrame()).getStackValue(index);
                Taint taint = Taint.merge(stackValue, this.getDefaultValue());
                if (stackValue.hasValidVariableIndex()) {
                    taint.setVariableIndex(stackValue.getVariableIndex());
                }
                taint.setRealInstanceClass(stackValue.getRealInstanceClass());
                taint.addLocation(this.getTaintLocation(), false);
                ((TaintFrame)this.getFrame()).setValue(((TaintFrame)this.getFrame()).getStackLocation(index), taint);
                this.setLocalVariableTaint(taint, taint);
            }
            catch (DataflowAnalysisException ex) {
                throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
            }
        }
    }

    private Taint mergeTransferParameters(Collection<Integer> transferParameters) {
        assert (transferParameters != null && !transferParameters.isEmpty());
        Taint taint = null;
        for (Integer transferParameter : transferParameters) {
            try {
                Taint value = (Taint)((TaintFrame)this.getFrame()).getStackValue(transferParameter);
                taint = Taint.merge(taint, value);
            }
            catch (DataflowAnalysisException ex) {
                throw new RuntimeException("Bad transfer parameter specification", ex);
            }
        }
        assert (taint != null);
        return taint;
    }

    private void transferTaintToMutables(TaintMethodSummary methodSummary, Taint taint) {
        block8: {
            assert (taint != null);
            if (methodSummary == null || !methodSummary.hasMutableStackIndeces()) {
                return;
            }
            try {
                int stackDepth = ((TaintFrame)this.getFrame()).getStackDepth();
                for (Integer mutableStackIndex : methodSummary.getMutableStackIndeces()) {
                    assert (mutableStackIndex >= 0);
                    if (mutableStackIndex >= stackDepth) {
                        if (!"<init>".equals(this.methodDescriptor.getName()) && !"<clinit>".equals(this.methodDescriptor.getName())) assert (false) : "Out of bounds mutables in " + this.methodDescriptor;
                        continue;
                    }
                    Taint stackValue = (Taint)((TaintFrame)this.getFrame()).getStackValue(mutableStackIndex);
                    this.setLocalVariableTaint(taint, stackValue);
                    Taint taintCopy = new Taint(taint);
                    taintCopy.setRealInstanceClass(stackValue.getRealInstanceClass());
                    ((TaintFrame)this.getFrame()).setValue(((TaintFrame)this.getFrame()).getStackLocation(mutableStackIndex), taintCopy);
                }
            }
            catch (DataflowAnalysisException ex) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
    }

    private void setLocalVariableTaint(Taint valueTaint, Taint indexTaint) {
        assert (valueTaint != null && indexTaint != null);
        if (!indexTaint.hasValidVariableIndex()) {
            return;
        }
        int index = indexTaint.getVariableIndex();
        if (index >= ((TaintFrame)this.getFrame()).getNumLocals()) {
            assert (false) : "Out of bounds local variable index in " + this.methodDescriptor;
            return;
        }
        valueTaint.setVariableIndex(index);
        ((TaintFrame)this.getFrame()).setValue(index, valueTaint);
    }

    private void pushSafe() {
        ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.SAFE));
    }

    private void pushSafeDebug(String debugInfo) {
        ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.SAFE).setDebugInfo(debugInfo));
    }

    private TaintLocation getTaintLocation() {
        return new TaintLocation(this.methodDescriptor, this.getLocation().getHandle().getPosition());
    }

    public void finishAnalysis() {
        String fullMethodName;
        assert (this.analyzedMethodSummary != null);
        Taint outputTaint = this.analyzedMethodSummary.getOutputTaint();
        if (outputTaint == null) {
            return;
        }
        String returnType = TaintFrameModelingVisitor.getReturnType(this.methodDescriptor.getSignature());
        if (SAFE_OBJECT_TYPES.contains(returnType) && outputTaint.getState() != Taint.State.NULL) {
            return;
        }
        String realInstanceClassName = outputTaint.getRealInstanceClassName();
        if (returnType.equals("L" + realInstanceClassName + ";")) {
            outputTaint.setRealInstanceClass(null);
            this.analyzedMethodSummary.setOuputTaint(outputTaint);
        }
        String className = this.methodDescriptor.getSlashedClassName();
        String methodId = "." + this.methodDescriptor.getName() + this.methodDescriptor.getSignature();
        if ((this.analyzedMethodSummary.isInformative() || this.getSuperMethodSummary(className, methodId) != null) && !this.methodSummaries.containsKey(fullMethodName = className.concat(methodId))) {
            this.methodSummaries.put(fullMethodName, this.analyzedMethodSummary);
        }
    }

    private void printStackState() {
        try {
            System.out.println("============================");
            System.out.println("[[ Stack ]]");
            int stackDepth = ((TaintFrame)this.getFrame()).getStackDepth();
            for (int i = 0; i < stackDepth; ++i) {
                Taint taintValue = (Taint)((TaintFrame)this.getFrame()).getStackValue(i);
                System.out.println(String.format("%s. %s {%s}", i, taintValue.getState().toString(), taintValue.getDebugInfo()));
            }
            if (stackDepth == 0) {
                System.out.println("Empty");
            }
            System.out.println("============================");
        }
        catch (DataflowAnalysisException e) {
            System.out.println("Oups " + e.getMessage());
        }
    }

    static {
        SAFE_OBJECT_TYPES.add("Ljava/lang/Boolean;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Character;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Double;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Float;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Integer;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Long;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Byte;");
        SAFE_OBJECT_TYPES.add("Ljava/lang/Short;");
        SAFE_OBJECT_TYPES.add("Ljava/math/BigDecimal;");
        IMMUTABLE_OBJECT_TYPES = new HashSet<String>(SAFE_OBJECT_TYPES.size() + 9);
        IMMUTABLE_OBJECT_TYPES.addAll(SAFE_OBJECT_TYPES);
        IMMUTABLE_OBJECT_TYPES.add("Ljava/lang/String;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/math/BigInteger;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/io/File;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/util/Locale;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/net/Inet4Address;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/net/Inet6Address;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/net/InetSocketAddress;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/net/URI;");
        IMMUTABLE_OBJECT_TYPES.add("Ljava/net/URL;");
    }
}

