/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TaintMethodSummary {
    private Taint outputTaint = null;
    private final Set<Integer> mutableStackIndices = new HashSet<Integer>();
    private final boolean isConfigured;
    public static final TaintMethodSummary SAFE_SUMMARY = new TaintMethodSummary(false);

    public TaintMethodSummary(boolean isConfigured) {
        this.isConfigured = isConfigured;
    }

    public Collection<Integer> getMutableStackIndeces() {
        if (!this.hasMutableStackIndeces()) {
            throw new IllegalStateException("stack indeces not set");
        }
        return Collections.unmodifiableCollection(this.mutableStackIndices);
    }

    public boolean hasMutableStackIndeces() {
        assert (this.mutableStackIndices != null);
        return !this.mutableStackIndices.isEmpty();
    }

    public void addMutableStackIndex(int mutableStackIndex) {
        if (mutableStackIndex < 0) {
            throw new IllegalArgumentException("negative index");
        }
        this.mutableStackIndices.add(mutableStackIndex);
    }

    public Taint getOutputTaint() {
        if (this.outputTaint == null) {
            return null;
        }
        return new Taint(this.outputTaint);
    }

    public void setOuputTaint(Taint taint) {
        if (taint == null) {
            this.outputTaint = null;
            return;
        }
        Taint taintCopy = new Taint(taint);
        taintCopy.invalidateVariableIndex();
        this.outputTaint = taintCopy;
    }

    public static TaintMethodSummary getDefaultConstructorSummary(int stackSize) {
        if (stackSize < 1) {
            throw new IllegalArgumentException("stack size less than 1");
        }
        TaintMethodSummary summary = new TaintMethodSummary(false);
        summary.outputTaint = new Taint(Taint.State.UNKNOWN);
        summary.mutableStackIndices.add(stackSize - 1);
        summary.mutableStackIndices.add(stackSize);
        return summary;
    }

    public boolean isInformative() {
        if (this == SAFE_SUMMARY) {
            return false;
        }
        if (this.outputTaint == null) {
            return false;
        }
        if (!this.outputTaint.isUnknown()) {
            return true;
        }
        if (this.outputTaint.hasParameters()) {
            return true;
        }
        return this.outputTaint.getRealInstanceClass() != null;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public String toString() {
        String realInstanceClassName;
        if (this.outputTaint == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.outputTaint.isUnknown() && this.outputTaint.hasParameters()) {
            TaintMethodSummary.appendJoined(sb, this.outputTaint.getParameters());
            Taint.State nonParametricState = this.outputTaint.getNonParametricState();
            assert (nonParametricState != null);
            if (nonParametricState != Taint.State.INVALID) {
                sb.append(",").append(nonParametricState.name());
            }
        } else {
            sb.append(this.outputTaint.getState().name());
        }
        if (this.hasMutableStackIndeces()) {
            sb.append("#");
            TaintMethodSummary.appendJoined(sb, this.mutableStackIndices);
        }
        if ((realInstanceClassName = this.outputTaint.getRealInstanceClassName()) != null) {
            sb.append(" (").append(realInstanceClassName).append(")");
        }
        return sb.toString();
    }

    private static void appendJoined(StringBuilder sb, Collection<Integer> objects) {
        assert (sb != null && objects != null);
        int count = objects.size();
        Integer[] array = objects.toArray(new Integer[count]);
        sb.append(array[0]);
        for (int i = 1; i < count; ++i) {
            sb.append(",").append(array[i]);
        }
    }

    public static TaintMethodSummary load(String str) throws IOException {
        if (str == null) {
            throw new NullPointerException("string is null");
        }
        str = str.trim();
        String[] tuple = str.split("#");
        TaintMethodSummary summary = new TaintMethodSummary(true);
        if (tuple.length == 2) {
            str = tuple[0];
            try {
                String[] indices;
                for (String index : indices = tuple[1].split(",")) {
                    summary.addMutableStackIndex(Integer.parseInt(index.trim()));
                }
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot parse mutable stack offsets", ex);
            }
        } else if (tuple.length != 1) {
            throw new IOException("Bad format: only one '#' expected");
        }
        if (str.isEmpty()) {
            throw new IOException("No taint information set");
        }
        if (TaintMethodSummary.isTaintStateValue(str)) {
            summary.setOuputTaint(Taint.valueOf(str));
        } else {
            tuple = str.split(",");
            int count = tuple.length;
            Taint taint = new Taint(Taint.State.UNKNOWN);
            for (int i = 0; i < count; ++i) {
                String indexOrState = tuple[i].trim();
                if (TaintMethodSummary.isTaintStateValue(indexOrState)) {
                    taint.setNonParametricState(Taint.State.valueOf(indexOrState));
                    continue;
                }
                try {
                    taint.addParameter(Integer.parseInt(indexOrState));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Cannot parse parameter offset " + i, ex);
                }
            }
            summary.setOuputTaint(taint);
        }
        return summary;
    }

    private static boolean isTaintStateValue(String value) {
        Taint.State[] states;
        assert (value != null && !value.isEmpty());
        for (Taint.State state : states = Taint.State.values()) {
            if (!state.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    static {
        TaintMethodSummary.SAFE_SUMMARY.outputTaint = new Taint(Taint.State.SAFE);
    }
}

