/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xss;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import com.h3xstream.findsecbugs.injection.ConfiguredBasicInjectionDetector;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.ClassContext;

public class XssJspDetector
extends ConfiguredBasicInjectionDetector {
    private static final String XSS_JSP_PRINT_TYPE = "XSS_JSP_PRINT";
    public static final String[] JSP_PARENT_CLASSES = new String[]{"org.apache.jasper.runtime.HttpJspBase", "weblogic.servlet.jsp.JspBase"};

    public XssJspDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("xss-jsp.txt", XSS_JSP_PRINT_TYPE);
    }

    @Override
    public boolean shouldAnalyzeClass(ClassContext classContext) {
        String className = classContext.getClassDescriptor().getDottedClassName();
        return InterfaceUtils.isSubtype(className, JSP_PARENT_CLASSES);
    }
}

