/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xss;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import com.h3xstream.findsecbugs.injection.ConfiguredBasicInjectionDetector;
import com.h3xstream.findsecbugs.xss.XssJspDetector;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.ClassContext;

public class XssServletDetector
extends ConfiguredBasicInjectionDetector {
    private static final String XSS_SERVLET_TYPE = "XSS_SERVLET";

    public XssServletDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("xss-servlet.txt", XSS_SERVLET_TYPE);
    }

    @Override
    public boolean shouldAnalyzeClass(ClassContext classContext) {
        String className = classContext.getClassDescriptor().getDottedClassName();
        return InterfaceUtils.isSubtype(className, "javax.servlet.http.HttpServlet") && !InterfaceUtils.isSubtype(className, XssJspDetector.JSP_PARENT_CLASSES);
    }
}

