/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class BadHexadecimalConversionDetector
implements Detector {
    protected static boolean DEBUG = false;
    private static final String BAD_HEXA_CONVERSION_TYPE = "BAD_HEXA_CONVERSION";
    private BugReporter bugReporter;

    public BadHexadecimalConversionDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(m);
            if (DEBUG) {
                System.out.println(">>> Method: " + m.getName());
            }
            boolean invokeMessageDigest = false;
            boolean invokeToHexString = false;
            ConstantPoolGen cpg = classContext.getConstantPoolGen();
            if (methodGen == null || methodGen.getInstructionList() == null) continue;
            Iterator itIns = methodGen.getInstructionList().iterator();
            while (itIns.hasNext()) {
                INVOKEVIRTUAL invoke;
                Instruction inst = ((InstructionHandle)itIns.next()).getInstruction();
                if (DEBUG) {
                    ByteCode.printOpCode(inst, cpg);
                }
                if (inst instanceof INVOKEVIRTUAL) {
                    invoke = (INVOKEVIRTUAL)inst;
                    if (!"java.security.MessageDigest".equals(invoke.getClassName(cpg)) || !"digest".equals(invoke.getMethodName(cpg))) continue;
                    invokeMessageDigest = true;
                    continue;
                }
                if (!(inst instanceof INVOKESTATIC) || !invokeMessageDigest || !"java.lang.Integer".equals((invoke = (INVOKESTATIC)inst).getClassName(cpg)) || !"toHexString".equals(invoke.getMethodName(cpg))) continue;
                invokeToHexString = true;
            }
            if (!invokeMessageDigest || !invokeToHexString) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BAD_HEXA_CONVERSION_TYPE, 2).addClassAndMethod(javaClass, m));
        }
    }

    public void report() {
    }
}

