/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.AbstractInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.SinksLoader;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class BasicInjectionDetector
extends AbstractInjectionDetector {
    private final Map<String, InjectionPoint> injectionMap = new HashMap<String, InjectionPoint>();
    private static final SinksLoader SINKS_LOADER = new SinksLoader();

    protected BasicInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        InjectionPoint injectionPoint = this.injectionMap.get(this.getFullMethodName(invoke, cpg));
        if (injectionPoint == null) {
            return InjectionPoint.NONE;
        }
        return injectionPoint;
    }

    protected void loadConfiguredSinks(InputStream stream, String bugType) throws IOException {
        SINKS_LOADER.loadSinks(stream, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void loadConfiguredSinks(String filename, String bugType) {
        SINKS_LOADER.loadConfiguredSinks(filename, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void loadSink(String line, String bugType) {
        SINKS_LOADER.loadSink(line, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void addParsedInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
        assert (!this.injectionMap.containsKey(fullMethodName));
        this.injectionMap.put(fullMethodName, injectionPoint);
    }

    private String getFullMethodName(InvokeInstruction invoke, ConstantPoolGen cpg) {
        return ClassName.toSlashedClassName((String)invoke.getReferenceType(cpg).toString()) + "." + invoke.getMethodName(cpg) + invoke.getSignature(cpg);
    }
}

