/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintLocation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.bcel.generic.ObjectType;

public class Taint {
    private State state;
    private static final int INVALID_INDEX = -1;
    private int variableIndex;
    private final Set<TaintLocation> taintLocations;
    private final Set<TaintLocation> unknownLocations;
    private final Set<Integer> parameters;
    private State nonParametricState;
    private ObjectType realInstanceClass;
    private final Set<Tag> tags;
    private final Set<Tag> tagsToRemove;
    private String constantValue;
    private String debugInfo = null;

    public Taint(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            throw new IllegalArgumentException("state not allowed");
        }
        this.state = state;
        this.variableIndex = -1;
        this.unknownLocations = new HashSet<TaintLocation>();
        this.taintLocations = new HashSet<TaintLocation>();
        this.parameters = new HashSet<Integer>();
        this.nonParametricState = State.INVALID;
        this.realInstanceClass = null;
        this.tags = EnumSet.noneOf(Tag.class);
        this.tagsToRemove = EnumSet.noneOf(Tag.class);
        this.constantValue = null;
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            this.debugInfo = "?";
        }
    }

    public Taint(Taint taint) {
        Objects.requireNonNull(taint, "taint is null");
        assert (taint.state != null);
        this.state = taint.state;
        this.variableIndex = taint.variableIndex;
        this.taintLocations = new HashSet<TaintLocation>(taint.taintLocations);
        this.unknownLocations = new HashSet<TaintLocation>(taint.unknownLocations);
        this.parameters = new HashSet<Integer>(taint.getParameters());
        this.nonParametricState = taint.nonParametricState;
        this.realInstanceClass = taint.realInstanceClass;
        this.tags = EnumSet.copyOf(taint.tags);
        this.tagsToRemove = EnumSet.copyOf(taint.tagsToRemove);
        this.constantValue = taint.constantValue;
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            this.debugInfo = taint.debugInfo;
        }
    }

    public State getState() {
        assert (this.state != null && this.state != State.INVALID);
        return this.state;
    }

    void setState(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            throw new IllegalArgumentException("state not allowed to be set");
        }
        this.state = state;
    }

    public int getVariableIndex() {
        if (this.variableIndex == -1) {
            throw new IllegalStateException("index not set or has been invalidated");
        }
        assert (this.variableIndex >= 0);
        return this.variableIndex;
    }

    public boolean hasValidVariableIndex() {
        return this.variableIndex != -1;
    }

    void setVariableIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index");
        }
        this.variableIndex = index;
    }

    void invalidateVariableIndex() {
        this.variableIndex = -1;
    }

    public void addLocation(TaintLocation location, boolean isKnownTaintSource) {
        Objects.requireNonNull(location, "location is null");
        if (isKnownTaintSource) {
            this.taintLocations.add(location);
        } else {
            this.unknownLocations.add(location);
        }
    }

    public Set<TaintLocation> getLocations() {
        if (this.taintLocations.isEmpty()) {
            return Collections.unmodifiableSet(this.unknownLocations);
        }
        return Collections.unmodifiableSet(this.taintLocations);
    }

    public boolean isSafe() {
        return this.state.isSafe;
    }

    public boolean isTainted() {
        return this.state.isTainted;
    }

    public boolean isUnknown() {
        return this.state.isUnknown;
    }

    void addParameter(int parameterIndex) {
        if (parameterIndex < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        this.parameters.add(parameterIndex);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public Set<Integer> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public State getNonParametricState() {
        return this.nonParametricState;
    }

    void setNonParametricState(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            throw new IllegalArgumentException("state not allowed to be set");
        }
        this.nonParametricState = state;
    }

    public ObjectType getRealInstanceClass() {
        return this.realInstanceClass;
    }

    void setRealInstanceClass(ObjectType objectType) {
        this.realInstanceClass = objectType;
    }

    public String getRealInstanceClassName() {
        if (this.realInstanceClass == null) {
            return null;
        }
        return ClassName.toSlashedClassName((String)this.realInstanceClass.getClassName());
    }

    public boolean addTag(Tag tag) {
        return this.tags.add(tag);
    }

    public boolean hasTag(Tag tag) {
        return this.tags.contains((Object)tag);
    }

    public boolean hasTags() {
        return !this.tags.isEmpty();
    }

    public Set<Tag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean removeTag(Tag tag) {
        this.tagsToRemove.add(tag);
        return this.tags.remove((Object)tag);
    }

    public boolean isRemovingTags() {
        return !this.tagsToRemove.isEmpty();
    }

    public Set<Tag> getTagsToRemove() {
        return Collections.unmodifiableSet(this.tagsToRemove);
    }

    public String getConstantValue() {
        return this.constantValue;
    }

    void setConstantValue(String value) {
        this.constantValue = value;
    }

    public static Taint valueOf(String stateName) {
        return Taint.valueOf(State.valueOf(stateName));
    }

    public static Taint valueOf(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            return null;
        }
        return new Taint(state);
    }

    public static Taint merge(Taint a, Taint b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return new Taint(b);
        }
        if (b == null) {
            return new Taint(a);
        }
        assert (a != null && b != null);
        Taint result = new Taint(State.merge(a.getState(), b.getState()));
        if (a.variableIndex == b.variableIndex) {
            result.variableIndex = a.variableIndex;
        }
        result.taintLocations.addAll(a.taintLocations);
        result.taintLocations.addAll(b.taintLocations);
        result.unknownLocations.addAll(a.unknownLocations);
        result.unknownLocations.addAll(b.unknownLocations);
        if (!result.isTainted()) {
            Taint.mergeParameters(a, b, result);
        }
        Taint.mergeRealInstanceClass(a, b, result);
        Taint.mergeTags(a, b, result);
        if (a.constantValue != null && a.constantValue.equals(b.constantValue)) {
            result.constantValue = a.constantValue;
        }
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            result.setDebugInfo("[" + a.getDebugInfo() + "]+[" + b.getDebugInfo() + "]");
        }
        assert (!result.hasParameters() || result.isUnknown());
        return result;
    }

    private static void mergeParameters(Taint a, Taint b, Taint result) {
        result.parameters.addAll(a.parameters);
        result.parameters.addAll(b.parameters);
        if (a.hasParameters()) {
            result.nonParametricState = b.hasParameters() ? State.merge(a.nonParametricState, b.nonParametricState) : State.merge(b.state, a.nonParametricState);
        } else if (b.hasParameters()) {
            result.nonParametricState = State.merge(a.state, b.nonParametricState);
        }
    }

    private static void mergeRealInstanceClass(Taint a, Taint b, Taint result) {
        if (a.realInstanceClass != null && b.realInstanceClass != null) {
            try {
                if (a.realInstanceClass.equals((Object)b.realInstanceClass) || b.realInstanceClass.subclassOf(a.realInstanceClass)) {
                    result.realInstanceClass = a.realInstanceClass;
                } else if (a.realInstanceClass.subclassOf(b.realInstanceClass)) {
                    result.realInstanceClass = b.realInstanceClass;
                }
            }
            catch (ClassNotFoundException ex) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
            }
        }
    }

    private static void mergeTags(Taint a, Taint b, Taint result) {
        if (a.isSafe()) {
            result.tags.addAll(b.tags);
        } else if (b.isSafe()) {
            result.tags.addAll(a.tags);
        } else {
            result.tags.addAll(a.tags);
            result.tags.retainAll(b.tags);
        }
        result.tagsToRemove.addAll(a.tagsToRemove);
        result.tagsToRemove.addAll(b.tagsToRemove);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Taint)) {
            return false;
        }
        Taint other = (Taint)obj;
        return this.state == other.state && this.variableIndex == other.variableIndex && this.taintLocations.equals(other.taintLocations) && this.unknownLocations.equals(other.unknownLocations) && this.parameters.equals(other.parameters) && this.nonParametricState == other.nonParametricState && Objects.equals(this.realInstanceClass, other.realInstanceClass) && this.tags.equals(other.tags) && Objects.equals(this.constantValue, other.constantValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.variableIndex, this.taintLocations, this.unknownLocations, this.parameters, this.nonParametricState, this.realInstanceClass, this.tags, this.constantValue});
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public Taint setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
        return this;
    }

    public String toString() {
        assert (this.state != null);
        StringBuilder sb = new StringBuilder(this.state.name().substring(0, 1));
        if (this.hasValidVariableIndex()) {
            sb.append(this.variableIndex);
        }
        if (!this.parameters.isEmpty()) {
            sb.append(this.parameters);
        }
        assert (this.nonParametricState != null);
        if (this.nonParametricState != State.INVALID) {
            sb.append('(').append(this.nonParametricState.name().substring(0, 1)).append(')');
        }
        if (this.debugInfo != null) {
            sb.append(" {").append(this.debugInfo).append('}');
        }
        if (this.tags.size() > 0) {
            sb.append(" tags: ").append(Arrays.toString(this.tags.toArray()));
        }
        return sb.toString();
    }

    public static enum Tag {
        XSS_SAFE,
        SQL_INJECTION_SAFE,
        COMMAND_INJECTION_SAFE,
        LDAP_INJECTION_SAFE,
        XPATH_INJECTION_SAFE,
        CR_ENCODED,
        LF_ENCODED,
        QUOTE_ENCODED,
        APOSTROPHE_ENCODED,
        LT_ENCODED;

    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State TAINTED = new State(false, true, false);
        public static final /* enum */ State UNKNOWN = new State(false, false, true);
        public static final /* enum */ State SAFE = new State(true, false, false);
        public static final /* enum */ State NULL = new State(true, false, false);
        public static final /* enum */ State INVALID = new State(false, false, false);
        private final boolean isSafe;
        private final boolean isTainted;
        private final boolean isUnknown;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(boolean isSafe, boolean isTainted, boolean isUnknown) {
            this.isSafe = isSafe;
            this.isTainted = isTainted;
            this.isUnknown = isUnknown;
        }

        public static State merge(State a, State b) {
            if (a == null || b == null) {
                throw new NullPointerException("use Taint.State." + INVALID.name() + " instead of null");
            }
            if (a == TAINTED || b == TAINTED) {
                return TAINTED;
            }
            if (a == UNKNOWN || b == UNKNOWN) {
                return UNKNOWN;
            }
            if (a == SAFE || b == SAFE) {
                return SAFE;
            }
            if (a == NULL || b == NULL) {
                return NULL;
            }
            assert (a == INVALID && b == INVALID);
            return INVALID;
        }

        static {
            $VALUES = new State[]{TAINTED, UNKNOWN, SAFE, NULL, INVALID};
        }
    }
}

