/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintAnalysis;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IMethodAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.generic.MethodGen;

public class TaintDataflowEngine
implements IMethodAnalysisEngine<TaintDataflow> {
    private static final FindSecBugsGlobalConfig CONFIG = FindSecBugsGlobalConfig.getInstance();
    private static final Logger LOGGER = Logger.getLogger(TaintDataflowEngine.class.getName());
    private static final String METHODS_SUMMARIES_PATH = "taint-config/";
    private static final String[] METHODS_SUMMARIES_FILENAMES = new String[]{"java-lang.txt", "java-ee.txt", "collections.txt", "java-net.txt", "scala.txt", "logging.txt", "other.txt"};
    private static final String SAFE_ENCODERS_PATH = "safe-encoders/";
    private static final String[] SAFE_ENCODERS_FILENAMES = new String[]{"owasp.txt", "apache-commons.txt", "other.txt"};
    private final TaintMethodSummaryMap methodSummaries = new TaintMethodSummaryMap();
    private static Writer writer = null;

    public TaintDataflowEngine() {
        String customConfigFile;
        for (String path : METHODS_SUMMARIES_FILENAMES) {
            this.loadMethodSummaries(METHODS_SUMMARIES_PATH.concat(path), true);
        }
        for (String path : SAFE_ENCODERS_FILENAMES) {
            this.loadMethodSummaries(SAFE_ENCODERS_PATH.concat(path), true);
        }
        if (CONFIG.isTaintedSystemVariables()) {
            this.loadMethodSummaries(METHODS_SUMMARIES_PATH.concat("tainted-system-variables.txt"), false);
            LOGGER.info("System variables are considered to be tainted");
        }
        if ((customConfigFile = CONFIG.getCustomConfigFile()) != null && !customConfigFile.isEmpty()) {
            this.addCustomSummaries(customConfigFile);
        }
        if (!CONFIG.isTaintedMainArgument()) {
            LOGGER.info("The argument of the main method is not considered tainted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMethodSummaries(String path, boolean checkRewrite) {
        assert (path != null && !path.isEmpty());
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(path);
            this.methodSummaries.load(stream, checkRewrite);
        }
        catch (IOException ex) {
            block5: {
                try {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)ex.getMessage());
                }
                catch (Throwable throwable) {
                    IO.close(stream);
                    throw throwable;
                }
            }
            IO.close((InputStream)stream);
        }
        IO.close((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomSummaries(String path) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(path);
            this.methodSummaries.load(stream, false);
            LOGGER.log(Level.INFO, "Custom taint config loaded from {0}", path);
        }
        catch (IOException ex) {
            try {
                AnalysisContext.logError((String)"cannot load custom taint config method summaries", (Exception)ex);
            }
            catch (Throwable throwable) {
                IO.close(stream);
                throw throwable;
            }
            IO.close((InputStream)stream);
        }
        IO.close((InputStream)stream);
    }

    public TaintDataflow analyze(IAnalysisCache cache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        TaintMethodSummary derivedSummary;
        CFG cfg = (CFG)cache.getMethodAnalysis(CFG.class, descriptor);
        DepthFirstSearch dfs = (DepthFirstSearch)cache.getMethodAnalysis(DepthFirstSearch.class, descriptor);
        MethodGen methodGen = (MethodGen)cache.getMethodAnalysis(MethodGen.class, descriptor);
        TaintAnalysis analysis = new TaintAnalysis(methodGen, dfs, descriptor, this.methodSummaries);
        TaintDataflow flow = new TaintDataflow(cfg, analysis);
        flow.execute();
        analysis.finishAnalysis();
        if (CONFIG.isDebugOutputSummaries() && writer != null && (derivedSummary = (TaintMethodSummary)this.methodSummaries.get(TaintDataflowEngine.getSlashedMethodName(methodGen))) != null) {
            try {
                writer.append(TaintDataflowEngine.getSlashedMethodName(methodGen) + ":" + derivedSummary + "\n");
                writer.flush();
            }
            catch (IOException ex) {
                AnalysisContext.logError((String)"cannot write derived summaries", (Exception)ex);
            }
        }
        return flow;
    }

    private static String getSlashedMethodName(MethodGen methodGen) {
        String methodNameWithSignature = methodGen.getName() + methodGen.getSignature();
        String slashedClassName = methodGen.getClassName().replace('.', '/');
        return slashedClassName + "." + methodNameWithSignature;
    }

    public void registerWith(IAnalysisCache iac) {
        iac.registerMethodAnalysisEngine(TaintDataflow.class, (IMethodAnalysisEngine)this);
    }

    static {
        if (CONFIG.isDebugOutputSummaries()) {
            try {
                String fileName = "derived-summaries.txt";
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("derived-summaries.txt"), "utf-8"));
                LOGGER.info("Derived method summaries will be output to derived-summaries.txt");
            }
            catch (UnsupportedEncodingException ex) {
                assert (false) : ex.getMessage();
            }
            catch (FileNotFoundException ex) {
                AnalysisContext.logError((String)"File for derived summaries cannot be created or opened", (Exception)ex);
            }
        }
    }
}

