/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMapLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class TaintMethodSummaryMap
extends HashMap<String, TaintMethodSummary> {
    private static final long serialVersionUID = 1L;
    private static final Pattern fullMethodPattern;

    public void dump(PrintStream output) {
        TreeSet keys = new TreeSet(this.keySet());
        for (String key : keys) {
            output.println(key + ":" + this.get(key));
        }
    }

    public void load(InputStream input, final boolean checkRewrite) throws IOException {
        new TaintMethodSummaryMapLoader().load(input, new TaintMethodSummaryMapLoader.TaintMethodSummaryReceiver(){

            @Override
            public void receiveTaintMethodSummary(String fullMethod, TaintMethodSummary taintMethodSummary) {
                if (!fullMethodPattern.matcher(fullMethod).matches()) {
                    throw new IllegalArgumentException("Invalid full method name " + fullMethod + " configured");
                }
                if (checkRewrite && TaintMethodSummaryMap.this.containsKey(fullMethod)) {
                    throw new IllegalStateException("Summary for " + fullMethod + " already loaded");
                }
                TaintMethodSummaryMap.this.put(fullMethod, taintMethodSummary);
            }
        });
    }

    static {
        String classWithPackageRegex = "([a-z][a-z0-9]*\\/)*[A-Z][a-zA-Z0-9\\$]*";
        String typeRegex = "(\\[)*((L" + classWithPackageRegex + ";)|B|C|D|F|I|J|S|Z)";
        String returnRegex = "(V|(" + typeRegex + "))";
        String methodRegex = "(([a-zA-Z][a-zA-Z0-9]*)|(<init>))";
        String signatureRegex = "\\((" + typeRegex + ")*\\)" + returnRegex;
        String fullMathodNameRegex = classWithPackageRegex + "\\." + methodRegex + signatureRegex;
        fullMethodPattern = Pattern.compile(fullMathodNameRegex);
    }
}

