/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TaintMethodSummaryMapLoader {
    public void load(InputStream input, TaintMethodSummaryReceiver receiver) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            this.putFromLine(line, receiver);
        }
    }

    private void putFromLine(String line, TaintMethodSummaryReceiver receiver) throws IOException {
        if (line.startsWith("-")) {
            return;
        }
        String[] tuple = line.split("\\:");
        if (tuple.length != 2) {
            throw new IOException("Line format is not 'method name:summary info'");
        }
        receiver.receiveTaintMethodSummary(tuple[0].trim(), TaintMethodSummary.load(tuple[1]));
    }

    public static interface TaintMethodSummaryReceiver {
        public void receiveTaintMethodSummary(String var1, TaintMethodSummary var2);
    }
}

