/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintTypeConfig;
import java.io.IOException;
import java.util.regex.Pattern;

public class TaintClassConfig
implements TaintTypeConfig {
    public static final Taint.State DEFAULT_TAINT_STATE = Taint.State.NULL;
    private static final String IMMUTABLE = "#IMMUTABLE";
    private Taint.State taintState = DEFAULT_TAINT_STATE;
    private boolean immutable;
    private static final Pattern typePattern;
    private static final Pattern summaryPattern;

    public static boolean accepts(String typeSignature, String summary) {
        return typePattern.matcher(typeSignature).matches() && summaryPattern.matcher(summary).matches();
    }

    @Override
    public TaintClassConfig load(String summary) throws IOException {
        if (summary == null) {
            throw new NullPointerException("Summary is null");
        }
        if ((summary = summary.trim()).isEmpty()) {
            throw new IOException("No taint class summary specified");
        }
        TaintClassConfig taintClassSummary = new TaintClassConfig();
        if (summary.endsWith(IMMUTABLE)) {
            taintClassSummary.immutable = true;
            summary = summary.substring(0, summary.length() - IMMUTABLE.length());
        }
        if (!summary.isEmpty()) {
            taintClassSummary.taintState = Taint.State.valueOf(summary);
        }
        return taintClassSummary;
    }

    public Taint.State getTaintState() {
        return this.taintState;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Taint.State getTaintState(Taint.State defaultState) {
        if (this.taintState.equals((Object)DEFAULT_TAINT_STATE)) {
            return defaultState;
        }
        return this.taintState;
    }

    static {
        String classWithPackageRegex = "([a-z][a-z0-9]*\\/)*[A-Z][a-zA-Z0-9\\$]*";
        String typeRegex = "(\\[)*((L" + classWithPackageRegex + ";)|B|C|D|F|I|J|S|Z)";
        typePattern = Pattern.compile(typeRegex);
        String summaryRegex = "([A-Z_]+|#IMMUTABLE|[A-Z_]+#IMMUTABLE)";
        summaryPattern = Pattern.compile(summaryRegex);
    }
}

