/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.serial;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class ObjectDeserializationDetector
implements Detector {
    private static final String OBJECT_DESERIALIZATION_TYPE = "OBJECT_DESERIALIZATION";
    protected static boolean DEBUG = false;
    private BugReporter bugReporter;
    private static List<String> OBJECT_INPUTSTREAM_READ_METHODS = Arrays.asList("readObject", "readUnshared", "readArray");

    public ObjectDeserializationDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            if (DEBUG) {
                System.out.println(">>> Method: " + m.getName());
            }
            try {
                if (OBJECT_INPUTSTREAM_READ_METHODS.contains(m.getName()) && InterfaceUtils.isSubtype(javaClass, "java.io.Serializable") || InterfaceUtils.isSubtype(javaClass, "java.lang.reflect.InvocationHandler")) continue;
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(m);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        if (methodGen == null || methodGen.getInstructionList() == null) {
            return;
        }
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            String methodName;
            InvokeInstruction invoke;
            String className;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof InvokeInstruction) || !"java.io.ObjectInputStream".equals(className = (invoke = (InvokeInstruction)inst).getClassName(cpg)) && !className.contains("InputStream") && !InterfaceUtils.isSubtype(className, "java.io.ObjectInputStream") || !OBJECT_INPUTSTREAM_READ_METHODS.contains(methodName = invoke.getMethodName(cpg))) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, OBJECT_DESERIALIZATION_TYPE, 1).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
        }
    }

    public void report() {
    }
}

