/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import edu.umd.cs.findbugs.SystemProperties;

public class FindSecBugsGlobalConfig {
    private static final FindSecBugsGlobalConfig instance = new FindSecBugsGlobalConfig();
    private String findSecBugsVersion = "1.6.0";
    private boolean debugPrintInstructionVisited = false;
    private boolean debugPrintInvocationVisited = false;
    private boolean debugTaintState = false;
    private boolean debugOutputTaintConfigs = Boolean.parseBoolean(this.loadFromSystem("findsecbugs.taint.outputconfigs", Boolean.FALSE.toString()));
    private boolean taintedSystemVariables = Boolean.parseBoolean(this.loadFromSystem("findsecbugs.taint.taintedsystemvariables", Boolean.FALSE.toString()));
    private String customConfigFile = this.loadFromSystem("findsecbugs.taint.customconfigfile", null);
    private boolean taintedMainArgument = Boolean.parseBoolean(this.loadFromSystem("findsecbugs.taint.taintedmainargument", Boolean.TRUE.toString()));
    private boolean reportPotentialXssWrongContext = Boolean.parseBoolean(this.loadFromSystem("findsecbugs.taint.reportpotentialxsswrongcontext", Boolean.FALSE.toString()));

    protected FindSecBugsGlobalConfig() {
    }

    public String loadFromSystem(String key, String defaultValue) {
        String value = System.getenv(key);
        if (value == null) {
            value = System.getenv(key.replace('.', '_'));
        }
        if ((value = SystemProperties.getProperty((String)key, (String)value)) == null) {
            return defaultValue;
        }
        return value;
    }

    public String getCustomConfigFile(String suffix) {
        return this.loadFromSystem("findsecbugs.injection.customconfigfile." + suffix, null);
    }

    public static FindSecBugsGlobalConfig getInstance() {
        return instance;
    }

    public String getFindSecBugsVersion() {
        return this.findSecBugsVersion;
    }

    public void setFindSecBugsVersion(String findSecBugsVersion) {
        this.findSecBugsVersion = findSecBugsVersion;
    }

    public boolean isDebugOutputTaintConfigs() {
        return this.debugOutputTaintConfigs;
    }

    public void setDebugOutputTaintConfigs(boolean debugOutputTaintConfigs) {
        this.debugOutputTaintConfigs = debugOutputTaintConfigs;
    }

    public boolean isDebugPrintInstructionVisited() {
        return this.debugPrintInstructionVisited;
    }

    public void setDebugPrintInstructionVisited(boolean debugPrintInstructionVisited) {
        this.debugPrintInstructionVisited = debugPrintInstructionVisited;
    }

    public boolean isDebugPrintInvocationVisited() {
        return this.debugPrintInvocationVisited;
    }

    public void setDebugPrintInvocationVisited(boolean debugPrintInvocationVisited) {
        this.debugPrintInvocationVisited = debugPrintInvocationVisited;
    }

    public boolean isDebugTaintState() {
        return this.debugTaintState;
    }

    public void setDebugTaintState(boolean debugTaintState) {
        this.debugTaintState = debugTaintState;
    }

    public boolean isTaintedSystemVariables() {
        return this.taintedSystemVariables;
    }

    public void setTaintedSystemVariables(boolean taintedSystemVariables) {
        this.taintedSystemVariables = taintedSystemVariables;
    }

    public String getCustomConfigFile() {
        return this.customConfigFile;
    }

    public void setCustomConfigFile(String customConfigFile) {
        this.customConfigFile = customConfigFile;
    }

    public boolean isTaintedMainArgument() {
        return this.taintedMainArgument;
    }

    public void setTaintedMainArgument(boolean taintedMainArguments) {
        this.taintedMainArgument = taintedMainArguments;
    }

    public boolean isReportPotentialXssWrongContext() {
        return this.reportPotentialXssWrongContext;
    }

    public void setReportPotentialXssWrongContext(boolean reportPotentialXssWrongContext) {
        this.reportPotentialXssWrongContext = reportPotentialXssWrongContext;
    }
}

