/*
 * Copyright 2010 James Pether Sörling
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *	$Id$
 *  $HeadURL$
*/
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.11
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2019.02.24 at 11:40:07 PM CET
//


package com.hack23.cia.model.external.riksdagen.dokumentstatus.impl;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.hack23.cia.model.common.api.ModelObject;


/**
 * The Class DocumentPersonReferenceData.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentPersonReferenceData", propOrder = {
    "personReferenceId",
    "referenceName",
    "partyShortCode",
    "orderNumber",
    "roleDescription"
})
@Entity(name = "DocumentPersonReferenceData")
@Table(name = "DOCUMENT_PERSON_REFERENCE_DA_0")
@Inheritance(strategy = InheritanceType.JOINED)
public class DocumentPersonReferenceData
    implements ModelObject
{

    /**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/** The person reference id. */
    @XmlElement(name = "intressent_id", required = true)
    protected String personReferenceId;

    /** The reference name. */
    @XmlElement(name = "namn", required = true)
    protected String referenceName;

    /** The party short code. */
    @XmlElement(name = "partibet", required = true)
    protected String partyShortCode;

    /** The order number. */
    @XmlElement(name = "ordning")
    protected int orderNumber;

    /** The role description. */
    @XmlElement(name = "roll", required = true)
    @XmlSchemaType(name = "string")
    protected DocumentPersonReferenceRoleType roleDescription;

    /** The hjid. */
    @XmlAttribute(name = "Hjid")
    protected Long hjid;

    /**
	 * Gets the person reference id.
	 *
	 * @return the person reference id
	 */
    @Basic
    @Column(name = "PERSON_REFERENCE_ID")
    public String getPersonReferenceId() {
        return personReferenceId;
    }

    /**
	 * Sets the person reference id.
	 *
	 * @param value the new person reference id
	 */
    public void setPersonReferenceId(final String value) {
        this.personReferenceId = value;
    }

    /**
	 * Gets the reference name.
	 *
	 * @return the reference name
	 */
    @Basic
    @Column(name = "REFERENCE_NAME")
    public String getReferenceName() {
        return referenceName;
    }

    /**
	 * Sets the reference name.
	 *
	 * @param value the new reference name
	 */
    public void setReferenceName(final String value) {
        this.referenceName = value;
    }

    /**
	 * Gets the party short code.
	 *
	 * @return the party short code
	 */
    @Basic
    @Column(name = "PARTY_SHORT_CODE")
    public String getPartyShortCode() {
        return partyShortCode;
    }

    /**
	 * Sets the party short code.
	 *
	 * @param value the new party short code
	 */
    public void setPartyShortCode(final String value) {
        this.partyShortCode = value;
    }

    /**
	 * Gets the order number.
	 *
	 * @return the order number
	 */
    @Basic
    @Column(name = "ORDER_NUMBER", precision = 10, scale = 0)
    public int getOrderNumber() {
        return orderNumber;
    }

    /**
	 * Sets the order number.
	 *
	 * @param value the new order number
	 */
    public void setOrderNumber(final int value) {
        this.orderNumber = value;
    }

    /**
	 * Gets the role description.
	 *
	 * @return the role description
	 */
    @Basic
    @Column(name = "ROLE_DESCRIPTION")
    @Enumerated(EnumType.STRING)
    public DocumentPersonReferenceRoleType getRoleDescription() {
        return roleDescription;
    }

    /**
	 * Sets the role description.
	 *
	 * @param value the new role description
	 */
    public void setRoleDescription(final DocumentPersonReferenceRoleType value) {
        this.roleDescription = value;
    }

    /**
	 * With person reference id.
	 *
	 * @param value the value
	 * @return the document person reference data
	 */
    public DocumentPersonReferenceData withPersonReferenceId(final String value) {
        setPersonReferenceId(value);
        return this;
    }

    /**
	 * With reference name.
	 *
	 * @param value the value
	 * @return the document person reference data
	 */
    public DocumentPersonReferenceData withReferenceName(final String value) {
        setReferenceName(value);
        return this;
    }

    /**
	 * With party short code.
	 *
	 * @param value the value
	 * @return the document person reference data
	 */
    public DocumentPersonReferenceData withPartyShortCode(final String value) {
        setPartyShortCode(value);
        return this;
    }

    /**
	 * With order number.
	 *
	 * @param value the value
	 * @return the document person reference data
	 */
    public DocumentPersonReferenceData withOrderNumber(final int value) {
        setOrderNumber(value);
        return this;
    }

    /**
	 * With role description.
	 *
	 * @param value the value
	 * @return the document person reference data
	 */
    public DocumentPersonReferenceData withRoleDescription(final DocumentPersonReferenceRoleType value) {
        setRoleDescription(value);
        return this;
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public final String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}



    /**
	 * Gets the hjid.
	 *
	 * @return the hjid
	 */
    @Id
    @Column(name = "HJID")
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getHjid() {
        return hjid;
    }

    /**
	 * Sets the hjid.
	 *
	 * @param value the new hjid
	 */
    public void setHjid(final Long value) {
        this.hjid = value;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
	public boolean equals(final Object object) {
    	return EqualsBuilder.reflectionEquals(this,object,"hjid");
    }


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public final int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

}
