/*
 * Copyright 2010 James Pether Sörling
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *	$Id$
 *  $HeadURL$
*/
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.11
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2019.02.24 at 11:40:10 PM CET
//


package com.hack23.cia.model.external.riksdagen.utskottsforslag.impl;

import java.math.BigInteger;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.hack23.cia.model.common.api.ModelObject;


/**
 * The Class AgainstProposalData.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AgainstProposalData", propOrder = {
    "numberValue",
    "header",
    "proposalType",
    "parties",
    "proposalIssueNumber"
})
@Entity(name = "AgainstProposalData")
@Table(name = "AGAINST_PROPOSAL_DATA")
@Inheritance(strategy = InheritanceType.JOINED)
public class AgainstProposalData
    implements ModelObject
{

    /**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/** The number value. */
    @XmlElement(name = "nummer", required = true)
    protected BigInteger numberValue;

    /** The header. */
    @XmlElement(name = "rubrik", required = true)
    protected String header;

    /** The proposal type. */
    @XmlElement(name = "typ", required = true)
    protected String proposalType;

    /** The parties. */
    @XmlElement(name = "partier", required = true)
    protected String parties;

    /** The proposal issue number. */
    @XmlElement(name = "utskottsforslag_punkt", required = true)
    protected BigInteger proposalIssueNumber;

    /** The hjid. */
    @XmlAttribute(name = "Hjid")
    protected Long hjid;

    /**
	 * Gets the number value.
	 *
	 * @return the number value
	 */
    @Basic
    @Column(name = "NUMBER_VALUE", precision = 20)
    public BigInteger getNumberValue() {
        return numberValue;
    }

    /**
	 * Sets the number value.
	 *
	 * @param value the new number value
	 */
    public void setNumberValue(final BigInteger value) {
        this.numberValue = value;
    }

    /**
	 * Gets the header.
	 *
	 * @return the header
	 */
    @Basic
    @Column(name = "HEADER")
    public String getHeader() {
        return header;
    }

    /**
	 * Sets the header.
	 *
	 * @param value the new header
	 */
    public void setHeader(final String value) {
        this.header = value;
    }

    /**
	 * Gets the proposal type.
	 *
	 * @return the proposal type
	 */
    @Basic
    @Column(name = "PROPOSAL_TYPE")
    public String getProposalType() {
        return proposalType;
    }

    /**
	 * Sets the proposal type.
	 *
	 * @param value the new proposal type
	 */
    public void setProposalType(final String value) {
        this.proposalType = value;
    }

    /**
	 * Gets the parties.
	 *
	 * @return the parties
	 */
    @Basic
    @Column(name = "PARTIES")
    public String getParties() {
        return parties;
    }

    /**
	 * Sets the parties.
	 *
	 * @param value the new parties
	 */
    public void setParties(final String value) {
        this.parties = value;
    }

    /**
	 * Gets the proposal issue number.
	 *
	 * @return the proposal issue number
	 */
    @Basic
    @Column(name = "PROPOSAL_ISSUE_NUMBER", precision = 20)
    public BigInteger getProposalIssueNumber() {
        return proposalIssueNumber;
    }

    /**
	 * Sets the proposal issue number.
	 *
	 * @param value the new proposal issue number
	 */
    public void setProposalIssueNumber(final BigInteger value) {
        this.proposalIssueNumber = value;
    }

    /**
	 * With number value.
	 *
	 * @param value the value
	 * @return the against proposal data
	 */
    public AgainstProposalData withNumberValue(final BigInteger value) {
        setNumberValue(value);
        return this;
    }

    /**
	 * With header.
	 *
	 * @param value the value
	 * @return the against proposal data
	 */
    public AgainstProposalData withHeader(final String value) {
        setHeader(value);
        return this;
    }

    /**
	 * With proposal type.
	 *
	 * @param value the value
	 * @return the against proposal data
	 */
    public AgainstProposalData withProposalType(final String value) {
        setProposalType(value);
        return this;
    }

    /**
	 * With parties.
	 *
	 * @param value the value
	 * @return the against proposal data
	 */
    public AgainstProposalData withParties(final String value) {
        setParties(value);
        return this;
    }

    /**
	 * With proposal issue number.
	 *
	 * @param value the value
	 * @return the against proposal data
	 */
    public AgainstProposalData withProposalIssueNumber(final BigInteger value) {
        setProposalIssueNumber(value);
        return this;
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public final String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}

    /**
	 * Gets the hjid.
	 *
	 * @return the hjid
	 */
    @Id
    @Column(name = "HJID")
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getHjid() {
        return hjid;
    }

    /**
	 * Sets the hjid.
	 *
	 * @param value the new hjid
	 */
    public void setHjid(final Long value) {
        this.hjid = value;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
	public boolean equals(final Object object) {
    	return EqualsBuilder.reflectionEquals(this,object,"hjid");
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public final int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

}
