/*
 * Copyright 2010 James Pether Sörling
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *	$Id$
 *  $HeadURL$
*/
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.11
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2019.02.24 at 11:40:10 PM CET
//


package com.hack23.cia.model.external.riksdagen.utskottsforslag.impl;

import java.math.BigInteger;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jvnet.hyperjaxb3.xml.bind.annotation.adapters.ElementAsString;
import org.jvnet.hyperjaxb3.xml.bind.annotation.adapters.XmlAdapterUtils;
import org.w3c.dom.Element;

import com.hack23.cia.model.common.api.ModelObject;


/**
 * The Class CommitteeProposalData.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CommitteeProposalData", propOrder = {
    "header",
    "issueNumber",
    "proposal",
    "decisionType",
    "againstProposalNumber",
    "againstProposalParties",
    "ballotId",
    "ballotSummary",
    "ballotUrlXml",
    "committeeReport",
    "winner",
    "rm"
})
@Entity(name = "CommitteeProposalData")
@Table(name = "COMMITTEE_PROPOSAL_DATA")
@Inheritance(strategy = InheritanceType.JOINED)
public class CommitteeProposalData
    implements ModelObject
{

    /**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/** The header. */
    @XmlElement(name = "rubrik", required = true)
    protected String header;

    /** The issue number. */
    @XmlElement(name = "punkt", required = true)
    protected BigInteger issueNumber;

    /** The proposal. */
    @XmlElement(name = "forslag", required = true)
    protected String proposal;

    /** The decision type. */
    @XmlElement(name = "beslutstyp", required = true)
    protected String decisionType;

    /** The against proposal number. */
    @XmlElement(name = "motforslag_nummer", required = true)
    protected BigInteger againstProposalNumber;

    /** The against proposal parties. */
    @XmlElement(name = "motforslag_partier", required = true)
    protected String againstProposalParties;

    /** The ballot id. */
    @XmlElement(name = "votering_id", required = true)
    protected String ballotId;

    /** The ballot summary. */
    @XmlAnyElement
    protected Element ballotSummary;

    /** The ballot url xml. */
    @XmlElement(name = "votering_url_xml", required = true)
    @XmlSchemaType(name = "anyURI")
    protected String ballotUrlXml;

    /** The committee report. */
    @XmlElement(name = "bet", required = true)
    protected String committeeReport;

    /** The winner. */
    @XmlElement(name = "vinnare", required = true)
    protected String winner;

    /** The rm. */
    @XmlElement(required = true)
    protected String rm;

    /** The hjid. */
    @XmlAttribute(name = "Hjid")
    protected Long hjid;

    /**
	 * Gets the header.
	 *
	 * @return the header
	 */
    @Basic
    @Column(name = "HEADER")
    public String getHeader() {
        return header;
    }

    /**
	 * Sets the header.
	 *
	 * @param value the new header
	 */
    public void setHeader(final String value) {
        this.header = value;
    }

    /**
	 * Gets the issue number.
	 *
	 * @return the issue number
	 */
    @Basic
    @Column(name = "ISSUE_NUMBER", precision = 20)
    public BigInteger getIssueNumber() {
        return issueNumber;
    }

    /**
	 * Sets the issue number.
	 *
	 * @param value the new issue number
	 */
    public void setIssueNumber(final BigInteger value) {
        this.issueNumber = value;
    }

    /**
	 * Gets the proposal.
	 *
	 * @return the proposal
	 */
    @Basic
    @Column(name = "PROPOSAL", length = 10485760)
    public String getProposal() {
        return proposal;
    }

    /**
	 * Sets the proposal.
	 *
	 * @param value the new proposal
	 */
    public void setProposal(final String value) {
        this.proposal = value;
    }

    /**
	 * Gets the decision type.
	 *
	 * @return the decision type
	 */
    @Basic
    @Column(name = "DECISION_TYPE")
    public String getDecisionType() {
        return decisionType;
    }

    /**
	 * Sets the decision type.
	 *
	 * @param value the new decision type
	 */
    public void setDecisionType(final String value) {
        this.decisionType = value;
    }

    /**
	 * Gets the against proposal number.
	 *
	 * @return the against proposal number
	 */
    @Basic
    @Column(name = "AGAINST_PROPOSAL_NUMBER", precision = 20)
    public BigInteger getAgainstProposalNumber() {
        return againstProposalNumber;
    }

    /**
	 * Sets the against proposal number.
	 *
	 * @param value the new against proposal number
	 */
    public void setAgainstProposalNumber(final BigInteger value) {
        this.againstProposalNumber = value;
    }

    /**
	 * Gets the against proposal parties.
	 *
	 * @return the against proposal parties
	 */
    @Basic
    @Column(name = "AGAINST_PROPOSAL_PARTIES")
    public String getAgainstProposalParties() {
        return againstProposalParties;
    }

    /**
	 * Sets the against proposal parties.
	 *
	 * @param value the new against proposal parties
	 */
    public void setAgainstProposalParties(final String value) {
        this.againstProposalParties = value;
    }

    /**
	 * Gets the ballot id.
	 *
	 * @return the ballot id
	 */
    @Basic
    @Column(name = "BALLOT_ID")
    public String getBallotId() {
        return ballotId;
    }

    /**
	 * Sets the ballot id.
	 *
	 * @param value the new ballot id
	 */
    public void setBallotId(final String value) {
        this.ballotId = value;
    }

    /**
	 * Gets the ballot summary.
	 *
	 * @return the ballot summary
	 */
    @Transient
    public Element getBallotSummary() {
        return ballotSummary;
    }

    /**
	 * Sets the ballot summary.
	 *
	 * @param value the new ballot summary
	 */
    public void setBallotSummary(final Element value) {
        this.ballotSummary = value;
    }

    /**
	 * Gets the ballot url xml.
	 *
	 * @return the ballot url xml
	 */
    @Basic
    @Column(name = "BALLOT_URL_XML")
    public String getBallotUrlXml() {
        return ballotUrlXml;
    }

    /**
	 * Sets the ballot url xml.
	 *
	 * @param value the new ballot url xml
	 */
    public void setBallotUrlXml(final String value) {
        this.ballotUrlXml = value;
    }

    /**
	 * Gets the committee report.
	 *
	 * @return the committee report
	 */
    @Basic
    @Column(name = "COMMITTEE_REPORT")
    public String getCommitteeReport() {
        return committeeReport;
    }

    /**
	 * Sets the committee report.
	 *
	 * @param value the new committee report
	 */
    public void setCommitteeReport(final String value) {
        this.committeeReport = value;
    }

    /**
	 * Gets the winner.
	 *
	 * @return the winner
	 */
    @Basic
    @Column(name = "WINNER")
    public String getWinner() {
        return winner;
    }

    /**
	 * Sets the winner.
	 *
	 * @param value the new winner
	 */
    public void setWinner(final String value) {
        this.winner = value;
    }

    /**
	 * Gets the rm.
	 *
	 * @return the rm
	 */
    @Basic
    @Column(name = "RM")
    public String getRm() {
        return rm;
    }

    /**
	 * Sets the rm.
	 *
	 * @param value the new rm
	 */
    public void setRm(final String value) {
        this.rm = value;
    }

    /**
	 * With header.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withHeader(final String value) {
        setHeader(value);
        return this;
    }

    /**
	 * With issue number.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withIssueNumber(final BigInteger value) {
        setIssueNumber(value);
        return this;
    }

    /**
	 * With proposal.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withProposal(final String value) {
        setProposal(value);
        return this;
    }

    /**
	 * With decision type.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withDecisionType(final String value) {
        setDecisionType(value);
        return this;
    }

    /**
	 * With against proposal number.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withAgainstProposalNumber(final BigInteger value) {
        setAgainstProposalNumber(value);
        return this;
    }

    /**
	 * With against proposal parties.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withAgainstProposalParties(final String value) {
        setAgainstProposalParties(value);
        return this;
    }

    /**
	 * With ballot id.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withBallotId(final String value) {
        setBallotId(value);
        return this;
    }

    /**
	 * With ballot summary.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withBallotSummary(final Element value) {
        setBallotSummary(value);
        return this;
    }

    /**
	 * With ballot url xml.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withBallotUrlXml(final String value) {
        setBallotUrlXml(value);
        return this;
    }

    /**
	 * With committee report.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withCommitteeReport(final String value) {
        setCommitteeReport(value);
        return this;
    }

    /**
	 * With winner.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withWinner(final String value) {
        setWinner(value);
        return this;
    }

    /**
	 * With rm.
	 *
	 * @param value the value
	 * @return the committee proposal data
	 */
    public CommitteeProposalData withRm(final String value) {
        setRm(value);
        return this;
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public final String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}



    /**
	 * Gets the hjid.
	 *
	 * @return the hjid
	 */
    @Id
    @Column(name = "HJID")
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getHjid() {
        return hjid;
    }

    /**
	 * Sets the hjid.
	 *
	 * @param value the new hjid
	 */
    public void setHjid(final Long value) {
        this.hjid = value;
    }

    /**
	 * Gets the ballot summary item.
	 *
	 * @return the ballot summary item
	 */
    @Basic
    @Column(name = "BALLOT_SUMMARY_ITEM")
    @Lob
    public String getBallotSummaryItem() {
        return XmlAdapterUtils.unmarshall(ElementAsString.class, this.getBallotSummary());
    }

    /**
	 * Sets the ballot summary item.
	 *
	 * @param target the new ballot summary item
	 */
    public void setBallotSummaryItem(final String target) {
        setBallotSummary(XmlAdapterUtils.marshall(ElementAsString.class, target));
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
	public boolean equals(final Object object) {
    	return EqualsBuilder.reflectionEquals(this,object,"hjid");
    }


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public final int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

}
