/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.external.val.impl;

import com.hack23.cia.model.external.val.kommunvalkrets.impl.SwedenCountyData;
import com.hack23.cia.model.external.val.kommunvalkrets.impl.SwedenCountyDataContainer;
import com.hack23.cia.model.external.val.landstingvalkrets.impl.SwedenCountyElectoralRegion;
import com.hack23.cia.model.external.val.landstingvalkrets.impl.SwedenCountyElectoralRegionContainer;
import com.hack23.cia.model.external.val.partier.impl.SwedenElectionRegion;
import com.hack23.cia.model.external.val.partier.impl.SwedenElectionType;
import com.hack23.cia.model.external.val.partier.impl.SwedenElectionTypeContainerElement;
import com.hack23.cia.model.external.val.partier.impl.SwedenPoliticalParty;
import com.hack23.cia.model.external.val.riksdagsvalkrets.impl.SwedenParliamentElectoralRegion;
import com.hack23.cia.model.external.val.riksdagsvalkrets.impl.SwedenParliamentElectoralRegionContainer;
import com.hack23.cia.service.external.common.api.XmlAgent;
import com.hack23.cia.service.external.common.api.XmlAgentException;
import com.hack23.cia.service.external.val.api.ValApi;
import com.hack23.cia.service.external.val.api.ValApiException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
final class ValApiImpl
implements ValApi {
    @Autowired
    private final XmlAgent xmlAgent;
    @Autowired
    @Qualifier(value="valPartierMarshaller")
    private Unmarshaller valPartierMarshaller;
    @Autowired
    @Qualifier(value="valRiksdagMarshaller")
    private Unmarshaller valRiksdagMarshaller;
    @Autowired
    @Qualifier(value="valLandstingMarshaller")
    private Unmarshaller valLandstingMarshaller;
    @Autowired
    @Qualifier(value="valKommunMarshaller")
    private Unmarshaller valKommunMarshaller;

    @Autowired
    public ValApiImpl(XmlAgent xmlAgent) {
        this.xmlAgent = xmlAgent;
    }

    @Override
    public List<SwedenElectionType> getElectionTypes() throws ValApiException {
        try {
            URL resource = ValApiImpl.class.getResource("/partier20151217.xml");
            return ((SwedenElectionTypeContainerElement)((JAXBElement)this.xmlAgent.unmarshallXml(this.valPartierMarshaller, resource.toString(), "http://partier.val.external.model.cia.hack23.com/impl", null, null)).getValue()).getElectionTypes();
        }
        catch (XmlAgentException e) {
            throw new ValApiException("Problem getElectionTypes", e);
        }
    }

    @Override
    public List<SwedenParliamentElectoralRegion> getParliamentElectoralRegions() throws ValApiException {
        try {
            URL resource = ValApiImpl.class.getResource("/riksdagsvalkrets.xml");
            return ((SwedenParliamentElectoralRegionContainer)((JAXBElement)this.xmlAgent.unmarshallXml(this.valRiksdagMarshaller, resource.toString(), "http://riksdagsvalkrets.val.external.model.cia.hack23.com/impl", null, null)).getValue()).getParliamentElectoralRegions();
        }
        catch (XmlAgentException e) {
            throw new ValApiException("Problem getParliamentElectoralRegions", e);
        }
    }

    @Override
    public List<SwedenCountyElectoralRegion> getCountyElectoralRegions() throws ValApiException {
        try {
            URL resource = ValApiImpl.class.getResource("/landstingvalkrets.xml");
            return ((SwedenCountyElectoralRegionContainer)((JAXBElement)this.xmlAgent.unmarshallXml(this.valLandstingMarshaller, resource.toString(), "http://landstingvalkrets.val.external.model.cia.hack23.com/impl", null, null)).getValue()).getCountyElectoralRegions();
        }
        catch (XmlAgentException e) {
            throw new ValApiException("Problem getCountyElectoralRegions", e);
        }
    }

    @Override
    public List<SwedenCountyData> getCountyRegions() throws ValApiException {
        try {
            URL resource = ValApiImpl.class.getResource("/kommunvalkrets.xml");
            return ((SwedenCountyDataContainer)((JAXBElement)this.xmlAgent.unmarshallXml(this.valKommunMarshaller, resource.toString(), "http://kommunvalkrets.val.external.model.cia.hack23.com/impl", null, null)).getValue()).getCountyRegions();
        }
        catch (XmlAgentException e) {
            throw new ValApiException("Problem getCountyRegions", e);
        }
    }

    @Override
    public SwedenElectionRegion getSwedenElectionRegion() throws ValApiException {
        URL resource = ValApiImpl.class.getResource("/partier20151217.xml");
        try {
            return ((SwedenElectionType)((SwedenElectionTypeContainerElement)((JAXBElement)this.xmlAgent.unmarshallXml(this.valPartierMarshaller, resource.toString(), "http://partier.val.external.model.cia.hack23.com/impl", null, null)).getValue()).getElectionTypes().get(0)).getRegion();
        }
        catch (XmlAgentException e) {
            throw new ValApiException("Problem getSwedenElectionRegion", e);
        }
    }

    @Override
    public List<SwedenPoliticalParty> getSwedenPoliticalParties() throws ValApiException {
        return this.getSwedenElectionRegion().getParties();
    }
}

