/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.external.worldbank.impl;

import com.hack23.cia.model.external.worldbank.countries.impl.CountriesElement;
import com.hack23.cia.model.external.worldbank.countries.impl.CountryElement;
import com.hack23.cia.service.external.common.api.XmlAgent;
import com.hack23.cia.service.external.common.api.XmlAgentException;
import com.hack23.cia.service.external.worldbank.api.DataFailureException;
import com.hack23.cia.service.external.worldbank.api.WorldBankCountryApi;
import com.hack23.cia.service.external.worldbank.impl.BaseWorldBankApiImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
final class WorldbankCountryApiImpl
extends BaseWorldBankApiImpl
implements WorldBankCountryApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldbankCountryApiImpl.class);
    private static final String COUNTRIES = "https://api.worldbank.org/v2/country?per_page=300";
    private static final String PROBLEM_GETTING_WORLDBANK_COUNTRY_LIST = "Problem getting worldbank country list";
    private static final String XMLNS_WB_HTTP_COUNTRIES_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL = "xmlns:wb=\"http://countries.worldbank.external.model.cia.hack23.com/impl\"";
    @Autowired
    @Qualifier(value="worldbankOrgCountriesMarshaller")
    private Unmarshaller countriesUnmarshaller;

    @Autowired
    public WorldbankCountryApiImpl(XmlAgent xmlAgent) {
        super(xmlAgent);
    }

    @Override
    public List<CountryElement> getCountries() throws DataFailureException {
        try {
            return ((CountriesElement)this.getXmlAgent().unmarshallXml(this.countriesUnmarshaller, COUNTRIES, null, "xmlns:wb=\"http://www.worldbank.org\"", XMLNS_WB_HTTP_COUNTRIES_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL)).getCountry();
        }
        catch (XmlAgentException e) {
            LOGGER.warn(PROBLEM_GETTING_WORLDBANK_COUNTRY_LIST);
            throw new DataFailureException((Exception)((Object)e));
        }
    }
}

