/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.external.worldbank.impl;

import com.hack23.cia.model.external.worldbank.data.impl.DataElement;
import com.hack23.cia.model.external.worldbank.data.impl.WorldBankData;
import com.hack23.cia.service.external.common.api.XmlAgent;
import com.hack23.cia.service.external.common.api.XmlAgentException;
import com.hack23.cia.service.external.worldbank.api.DataFailureException;
import com.hack23.cia.service.external.worldbank.api.WorldBankDataApi;
import com.hack23.cia.service.external.worldbank.impl.BaseWorldBankApiImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
final class WorldbankDataApiImpl
extends BaseWorldBankApiImpl
implements WorldBankDataApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldbankDataApiImpl.class);
    private static final String COUNTRY_KEY = "${COUNTRY_KEY}";
    private static final String INDICATOR_COUNTRY_DATA = "https://api.worldbank.org/v2/countries/${COUNTRY_KEY}/indicators/${INDICATOR_KEY}?per_page=1000";
    private static final String INDICATOR_KEY = "${INDICATOR_KEY}";
    private static final String PROBLEM_GETTING_WORLDBANK_DATA_FOR_COUNTRY_CODE_S_INDICATOR_ID_S = "Problem getting worldbank data for countryCode:{} ,indicatorId:{} ";
    private static final String XMLNS_WB_HTTP_DATA_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL = "xmlns:wb=\"http://data.worldbank.external.model.cia.hack23.com/impl\"";
    @Autowired
    @Qualifier(value="worldbankOrgDataMarshaller")
    private Unmarshaller dataUnmarshaller;

    @Autowired
    public WorldbankDataApiImpl(XmlAgent xmlAgent) {
        super(xmlAgent);
    }

    @Override
    public List<WorldBankData> getData(String countryCode, String indicatorId) throws DataFailureException {
        try {
            String url = INDICATOR_COUNTRY_DATA.replace(COUNTRY_KEY, countryCode);
            return ((DataElement)this.getXmlAgent().unmarshallXml(this.dataUnmarshaller, url.replace(INDICATOR_KEY, indicatorId), null, "xmlns:wb=\"http://www.worldbank.org\"", XMLNS_WB_HTTP_DATA_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL)).getData();
        }
        catch (XmlAgentException e) {
            LOGGER.warn(PROBLEM_GETTING_WORLDBANK_DATA_FOR_COUNTRY_CODE_S_INDICATOR_ID_S, (Object)countryCode, (Object)indicatorId);
            throw new DataFailureException((Exception)((Object)e));
        }
    }
}

