/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.external.worldbank.impl;

import com.hack23.cia.model.external.worldbank.indicators.impl.IndicatorElement;
import com.hack23.cia.model.external.worldbank.indicators.impl.IndicatorsElement;
import com.hack23.cia.service.external.common.api.XmlAgent;
import com.hack23.cia.service.external.common.api.XmlAgentException;
import com.hack23.cia.service.external.worldbank.api.DataFailureException;
import com.hack23.cia.service.external.worldbank.api.WorldBankIndicatorApi;
import com.hack23.cia.service.external.worldbank.impl.BaseWorldBankApiImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
final class WorldbankIndicatorApiImpl
extends BaseWorldBankApiImpl
implements WorldBankIndicatorApi {
    private static final int IGNORE_TOP_HEADERS_LINE = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldbankIndicatorApiImpl.class);
    private static final String INDICATORS = "https://api.worldbank.org/v2/indicators?per_page=5000";
    private static final String PAGE_NUMBER = "&page=";
    private static final String PROBLEM_GETTING_WORLDBANK_INDICATOR_LIST = "Problem getting worldbank indicator list";
    private static final int SECOND_PAGE = 2;
    private static final String XMLNS_WB_HTTP_INDICATORS_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL = "xmlns:wb=\"http://indicators.worldbank.external.model.cia.hack23.com/impl\"";
    @Autowired
    @Qualifier(value="worldbankOrgIndicatorsMarshaller")
    private Unmarshaller indicatorsUnmarshaller;

    @Autowired
    public WorldbankIndicatorApiImpl(XmlAgent xmlAgent) {
        super(xmlAgent);
    }

    @Override
    public List<IndicatorElement> getIndicators() throws DataFailureException {
        ArrayList<IndicatorElement> result = new ArrayList<IndicatorElement>();
        try {
            IndicatorsElement firstPage = (IndicatorsElement)this.getXmlAgent().unmarshallXml(this.indicatorsUnmarshaller, INDICATORS, null, "xmlns:wb=\"http://www.worldbank.org\"", XMLNS_WB_HTTP_INDICATORS_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL);
            result.addAll(firstPage.getIndicator());
            for (int pageNumber = 2; pageNumber < firstPage.getPages().intValue(); ++pageNumber) {
                IndicatorsElement otherPageResult = (IndicatorsElement)this.getXmlAgent().unmarshallXml(this.indicatorsUnmarshaller, "https://api.worldbank.org/v2/indicators?per_page=5000&page=" + pageNumber, null, "xmlns:wb=\"http://www.worldbank.org\"", XMLNS_WB_HTTP_INDICATORS_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL);
                result.addAll(otherPageResult.getIndicator());
            }
        }
        catch (XmlAgentException e) {
            LOGGER.warn(PROBLEM_GETTING_WORLDBANK_INDICATOR_LIST);
            throw new DataFailureException((Exception)((Object)e));
        }
        return result;
    }

    @Override
    public List<String> getIndicatorsWithSwedishData() throws DataFailureException {
        try {
            return Collections.unmodifiableList(WorldbankIndicatorApiImpl.readUsingZipInputStream(Request.Get((String)"http://api.worldbank.org/v2/en/country/SWE?downloadformat=csv").execute().returnContent().asStream()));
        }
        catch (IOException e) {
            throw new DataFailureException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readUsingZipInputStream(InputStream inputStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ArrayList<String> list = new ArrayList<String>();
        try (ZipInputStream is = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                if (!entry.getName().startsWith("API_SWE_")) continue;
                list.addAll(WorldbankIndicatorApiImpl.readCsvContent(is));
            }
        }
        return list;
    }

    private static List<String> readCsvContent(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        for (int i = 0; i < 4; ++i) {
            String string = reader.readLine();
        }
        CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)CSVFormat.EXCEL.builder().setHeader(new String[0]).setDelimiter(',').build());
        List records = parser.getRecords();
        records.remove(0);
        ArrayList<String> list = new ArrayList<String>();
        for (CSVRecord csvRecord : records) {
            list.add(csvRecord.get("Indicator Code"));
        }
        return list;
    }
}

