/*
 * Decompiled with CFR 0.152.
 */
package com.hack23.cia.service.external.worldbank.impl;

import com.hack23.cia.model.external.worldbank.topic.impl.TopicElement;
import com.hack23.cia.model.external.worldbank.topic.impl.TopicsElement;
import com.hack23.cia.service.external.common.api.XmlAgent;
import com.hack23.cia.service.external.common.api.XmlAgentException;
import com.hack23.cia.service.external.worldbank.api.DataFailureException;
import com.hack23.cia.service.external.worldbank.api.WorldBankTopicApi;
import com.hack23.cia.service.external.worldbank.impl.BaseWorldBankApiImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
final class WorldbankTopicApiImpl
extends BaseWorldBankApiImpl
implements WorldBankTopicApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorldbankTopicApiImpl.class);
    private static final String PROBLEM_GETTING_WORLDBANK_TOPIC_LIST = "Problem getting worldbank topic list";
    private static final String TOPICS = "https://api.worldbank.org/v2/topics?per_page=3000";
    private static final String XMLNS_WB_HTTP_TOPIC_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL = "xmlns:wb=\"http://topic.worldbank.external.model.cia.hack23.com/impl\"";
    @Autowired
    @Qualifier(value="worldbankOrgTopicsMarshaller")
    private Unmarshaller topicsUnmarshaller;

    @Autowired
    public WorldbankTopicApiImpl(XmlAgent xmlAgent) {
        super(xmlAgent);
    }

    @Override
    public List<TopicElement> getTopics() throws DataFailureException {
        try {
            return ((TopicsElement)this.getXmlAgent().unmarshallXml(this.topicsUnmarshaller, TOPICS, null, "xmlns:wb=\"http://www.worldbank.org\"", XMLNS_WB_HTTP_TOPIC_WORLDBANK_EXTERNAL_MODEL_CIA_HACK23_COM_IMPL)).getTopic();
        }
        catch (XmlAgentException e) {
            LOGGER.warn(PROBLEM_GETTING_WORLDBANK_TOPIC_LIST);
            throw new DataFailureException((Exception)((Object)e));
        }
    }
}

