/*
 * Decompiled with CFR 0.152.
 */
package com.halilibo.richtext.commonmark;

import androidx.compose.runtime.internal.StabilityInferred;
import com.halilibo.richtext.commonmark.AstNodeConvertKt;
import com.halilibo.richtext.commonmark.CommonMarkdownParseOptions;
import com.halilibo.richtext.markdown.node.AstNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/halilibo/richtext/commonmark/CommonmarkAstNodeParser;", "", "options", "Lcom/halilibo/richtext/commonmark/CommonMarkdownParseOptions;", "<init>", "(Lcom/halilibo/richtext/commonmark/CommonMarkdownParseOptions;)V", "parser", "Lorg/commonmark/parser/Parser;", "kotlin.jvm.PlatformType", "Lorg/commonmark/parser/Parser;", "parse", "Lcom/halilibo/richtext/markdown/node/AstNode;", "text", "", "richtext-commonmark"})
@StabilityInferred(parameters=0)
public final class CommonmarkAstNodeParser {
    private final Parser parser;
    public static final int $stable = 8;

    public CommonmarkAstNodeParser(@NotNull CommonMarkdownParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object[] objectArray = new Extension[]{TablesExtension.create(), StrikethroughExtension.create(), options.getAutolink() ? AutolinkExtension.create() : null};
        this.parser = Parser.builder().extensions((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)).build();
    }

    public /* synthetic */ CommonmarkAstNodeParser(CommonMarkdownParseOptions commonMarkdownParseOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            commonMarkdownParseOptions = CommonMarkdownParseOptions.Companion.getDefault();
        }
        this(commonMarkdownParseOptions);
    }

    @NotNull
    public final AstNode parse(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Node node = this.parser.parse(text);
        if (node == null) {
            throw new IllegalArgumentException("Could not parse the given text content into a meaningful Markdown representation!");
        }
        Node commonmarkNode = node;
        AstNode astNode = AstNodeConvertKt.convert$default(commonmarkNode, null, null, 6, null);
        if (astNode == null) {
            throw new IllegalArgumentException("Could not convert the generated Commonmark Node into an ASTNode!");
        }
        return astNode;
    }

    public CommonmarkAstNodeParser() {
        this(null, 1, null);
    }
}

