/*
 * Decompiled with CFR 0.152.
 */
package com.android.debug.hv;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ViewServer
implements Runnable {
    private static final int VIEW_SERVER_DEFAULT_PORT = 4939;
    private static final int VIEW_SERVER_MAX_CONNECTIONS = 10;
    private static final String BUILD_TYPE_USER = "user";
    private static final String LOG_TAG = "ViewServer";
    private static final String VALUE_PROTOCOL_VERSION = "4";
    private static final String VALUE_SERVER_VERSION = "4";
    private static final String COMMAND_PROTOCOL_VERSION = "PROTOCOL";
    private static final String COMMAND_SERVER_VERSION = "SERVER";
    private static final String COMMAND_WINDOW_MANAGER_LIST = "LIST";
    private static final String COMMAND_WINDOW_MANAGER_AUTOLIST = "AUTOLIST";
    private static final String COMMAND_WINDOW_MANAGER_GET_FOCUS = "GET_FOCUS";
    private ServerSocket mServer;
    private final int mPort;
    private Thread mThread;
    private ExecutorService mThreadPool;
    private final List<WindowListener> mListeners = new CopyOnWriteArrayList<WindowListener>();
    private final HashMap<View, String> mWindows = new HashMap();
    private final ReentrantReadWriteLock mWindowsLock = new ReentrantReadWriteLock();
    private View mFocusedWindow;
    private final ReentrantReadWriteLock mFocusLock = new ReentrantReadWriteLock();
    private static ViewServer sServer;

    public static ViewServer get(Context context) {
        ApplicationInfo info = context.getApplicationInfo();
        if (BUILD_TYPE_USER.equals(Build.TYPE) && (info.flags & 2) != 0) {
            if (sServer == null) {
                sServer = new ViewServer(4939);
            }
            if (!sServer.isRunning()) {
                try {
                    sServer.start();
                }
                catch (IOException e) {
                    Log.d((String)LOG_TAG, (String)"Error:", (Throwable)e);
                }
            }
        } else {
            sServer = new NoopViewServer();
        }
        return sServer;
    }

    private ViewServer() {
        this.mPort = -1;
    }

    private ViewServer(int port) {
        this.mPort = port;
    }

    public boolean start() throws IOException {
        if (this.mThread != null) {
            return false;
        }
        this.mThread = new Thread((Runnable)this, "Local View Server [port=" + this.mPort + "]");
        this.mThreadPool = Executors.newFixedThreadPool(10);
        this.mThread.start();
        return true;
    }

    public boolean stop() {
        if (this.mThread != null) {
            this.mThread.interrupt();
            if (this.mThreadPool != null) {
                try {
                    this.mThreadPool.shutdownNow();
                }
                catch (SecurityException e) {
                    Log.w((String)LOG_TAG, (String)"Could not stop all view server threads");
                }
            }
            this.mThreadPool = null;
            this.mThread = null;
            try {
                this.mServer.close();
                this.mServer = null;
                return true;
            }
            catch (IOException e) {
                Log.w((String)LOG_TAG, (String)"Could not close the view server");
            }
        }
        this.mWindowsLock.writeLock().lock();
        try {
            this.mWindows.clear();
        }
        finally {
            this.mWindowsLock.writeLock().unlock();
        }
        this.mFocusLock.writeLock().lock();
        try {
            this.mFocusedWindow = null;
        }
        finally {
            this.mFocusLock.writeLock().unlock();
        }
        return false;
    }

    public boolean isRunning() {
        return this.mThread != null && this.mThread.isAlive();
    }

    public void addWindow(Activity activity) {
        String name = activity.getTitle().toString();
        name = TextUtils.isEmpty((CharSequence)name) ? activity.getClass().getCanonicalName() + "/0x" + System.identityHashCode(activity) : name + "(" + activity.getClass().getCanonicalName() + ")";
        this.addWindow(activity.getWindow().getDecorView(), name);
    }

    public void removeWindow(Activity activity) {
        this.removeWindow(activity.getWindow().getDecorView());
    }

    public void addWindow(View view, String name) {
        this.mWindowsLock.writeLock().lock();
        try {
            this.mWindows.put(view.getRootView(), name);
        }
        finally {
            this.mWindowsLock.writeLock().unlock();
        }
        this.fireWindowsChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(View view) {
        View rootView;
        this.mWindowsLock.writeLock().lock();
        try {
            rootView = view.getRootView();
            this.mWindows.remove(rootView);
        }
        finally {
            this.mWindowsLock.writeLock().unlock();
        }
        this.mFocusLock.writeLock().lock();
        try {
            if (this.mFocusedWindow == rootView) {
                this.mFocusedWindow = null;
            }
        }
        finally {
            this.mFocusLock.writeLock().unlock();
        }
        this.fireWindowsChangedEvent();
    }

    public void setFocusedWindow(Activity activity) {
        this.setFocusedWindow(activity.getWindow().getDecorView());
    }

    public void setFocusedWindow(View view) {
        this.mFocusLock.writeLock().lock();
        try {
            this.mFocusedWindow = view == null ? null : view.getRootView();
        }
        finally {
            this.mFocusLock.writeLock().unlock();
        }
        this.fireFocusChangedEvent();
    }

    @Override
    public void run() {
        try {
            this.mServer = new ServerSocket(this.mPort, 10, InetAddress.getLocalHost());
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)"Starting ServerSocket error: ", (Throwable)e);
        }
        while (this.mServer != null && Thread.currentThread() == this.mThread) {
            try {
                Socket client = this.mServer.accept();
                if (this.mThreadPool != null) {
                    this.mThreadPool.submit(new ViewServerWorker(client));
                    continue;
                }
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Log.w((String)LOG_TAG, (String)"Connection error: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeValue(Socket client, String value) {
        boolean result;
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            out.write(value);
            out.write("\n");
            out.flush();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    private void fireWindowsChangedEvent() {
        for (WindowListener listener : this.mListeners) {
            listener.windowsChanged();
        }
    }

    private void fireFocusChangedEvent() {
        for (WindowListener listener : this.mListeners) {
            listener.focusChanged();
        }
    }

    private void addWindowListener(WindowListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    private void removeWindowListener(WindowListener listener) {
        this.mListeners.remove(listener);
    }

    private class ViewServerWorker
    implements Runnable,
    WindowListener {
        private Socket mClient;
        private boolean mNeedWindowListUpdate;
        private boolean mNeedFocusedWindowUpdate;
        private final Object[] mLock = new Object[0];

        public ViewServerWorker(Socket client) {
            this.mClient = client;
            this.mNeedWindowListUpdate = false;
            this.mNeedFocusedWindowUpdate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader in = null;
            try {
                String parameters;
                String command;
                in = new BufferedReader(new InputStreamReader(this.mClient.getInputStream()), 1024);
                String request = in.readLine();
                int index = request.indexOf(32);
                if (index == -1) {
                    command = request;
                    parameters = "";
                } else {
                    command = request.substring(0, index);
                    parameters = request.substring(index + 1);
                }
                boolean result = ViewServer.COMMAND_PROTOCOL_VERSION.equalsIgnoreCase(command) ? ViewServer.writeValue(this.mClient, "4") : (ViewServer.COMMAND_SERVER_VERSION.equalsIgnoreCase(command) ? ViewServer.writeValue(this.mClient, "4") : (ViewServer.COMMAND_WINDOW_MANAGER_LIST.equalsIgnoreCase(command) ? this.listWindows(this.mClient) : (ViewServer.COMMAND_WINDOW_MANAGER_GET_FOCUS.equalsIgnoreCase(command) ? this.getFocusedWindow(this.mClient) : (ViewServer.COMMAND_WINDOW_MANAGER_AUTOLIST.equalsIgnoreCase(command) ? this.windowManagerAutolistLoop() : this.windowCommand(this.mClient, command, parameters)))));
                if (!result) {
                    Log.w((String)ViewServer.LOG_TAG, (String)("An error occurred with the command: " + command));
                }
            }
            catch (IOException e) {
                Log.w((String)ViewServer.LOG_TAG, (String)"Connection error: ", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mClient != null) {
                    try {
                        this.mClient.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean windowCommand(Socket client, String command, String parameters) {
            boolean success = true;
            BufferedWriter out = null;
            try {
                int index = parameters.indexOf(32);
                if (index == -1) {
                    index = parameters.length();
                }
                String code = parameters.substring(0, index);
                int hashCode = (int)Long.parseLong(code, 16);
                parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
                View window = this.findWindow(hashCode);
                if (window == null) {
                    boolean bl = false;
                    return bl;
                }
                Method dispatch = ViewDebug.class.getDeclaredMethod("dispatchCommand", View.class, String.class, String.class, OutputStream.class);
                dispatch.setAccessible(true);
                dispatch.invoke(null, window, command, parameters, new UncloseableOutputStream(client.getOutputStream()));
                if (!client.isOutputShutdown()) {
                    out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                    out.write("DONE\n");
                    out.flush();
                }
            }
            catch (Exception e) {
                Log.w((String)ViewServer.LOG_TAG, (String)("Could not send command " + command + " with parameters " + parameters), (Throwable)e);
                success = false;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        success = false;
                    }
                }
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private View findWindow(int hashCode) {
            if (hashCode == -1) {
                View window = null;
                ViewServer.this.mWindowsLock.readLock().lock();
                try {
                    window = ViewServer.this.mFocusedWindow;
                }
                finally {
                    ViewServer.this.mWindowsLock.readLock().unlock();
                }
                return window;
            }
            ViewServer.this.mWindowsLock.readLock().lock();
            try {
                for (Map.Entry entry : ViewServer.this.mWindows.entrySet()) {
                    if (System.identityHashCode(entry.getKey()) != hashCode) continue;
                    View view = (View)entry.getKey();
                    return view;
                }
            }
            finally {
                ViewServer.this.mWindowsLock.readLock().unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean listWindows(Socket client) {
            boolean result = true;
            BufferedWriter out = null;
            try {
                ViewServer.this.mWindowsLock.readLock().lock();
                OutputStream clientStream = client.getOutputStream();
                out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
                for (Map.Entry entry : ViewServer.this.mWindows.entrySet()) {
                    out.write(Integer.toHexString(System.identityHashCode(entry.getKey())));
                    out.write(32);
                    out.append((CharSequence)entry.getValue());
                    out.write(10);
                }
                out.write("DONE.\n");
                out.flush();
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                ViewServer.this.mWindowsLock.readLock().unlock();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        result = false;
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getFocusedWindow(Socket client) {
            boolean result = true;
            String focusName = null;
            BufferedWriter out = null;
            try {
                OutputStream clientStream = client.getOutputStream();
                out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
                View focusedWindow = null;
                ViewServer.this.mFocusLock.readLock().lock();
                try {
                    focusedWindow = ViewServer.this.mFocusedWindow;
                }
                finally {
                    ViewServer.this.mFocusLock.readLock().unlock();
                }
                if (focusedWindow != null) {
                    ViewServer.this.mWindowsLock.readLock().lock();
                    try {
                        focusName = (String)ViewServer.this.mWindows.get(ViewServer.this.mFocusedWindow);
                    }
                    finally {
                        ViewServer.this.mWindowsLock.readLock().unlock();
                    }
                    out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                    out.write(32);
                    out.append(focusName);
                }
                out.write(10);
                out.flush();
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        result = false;
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowsChanged() {
            Object[] objectArray = this.mLock;
            synchronized (this.mLock) {
                this.mNeedWindowListUpdate = true;
                this.mLock.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusChanged() {
            Object[] objectArray = this.mLock;
            synchronized (this.mLock) {
                this.mNeedFocusedWindowUpdate = true;
                this.mLock.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean windowManagerAutolistLoop() {
            ViewServer.this.addWindowListener(this);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter(this.mClient.getOutputStream()));
                while (!Thread.interrupted()) {
                    boolean needWindowListUpdate = false;
                    boolean needFocusedWindowUpdate = false;
                    Object[] objectArray = this.mLock;
                    // MONITORENTER : this.mLock
                    while (!this.mNeedWindowListUpdate && !this.mNeedFocusedWindowUpdate) {
                        this.mLock.wait();
                    }
                    if (this.mNeedWindowListUpdate) {
                        this.mNeedWindowListUpdate = false;
                        needWindowListUpdate = true;
                    }
                    if (this.mNeedFocusedWindowUpdate) {
                        this.mNeedFocusedWindowUpdate = false;
                        needFocusedWindowUpdate = true;
                    }
                    // MONITOREXIT : objectArray
                    if (needWindowListUpdate) {
                        out.write("LIST UPDATE\n");
                        out.flush();
                    }
                    if (!needFocusedWindowUpdate) continue;
                    out.write("FOCUS UPDATE\n");
                    out.flush();
                }
                return true;
            }
            catch (Exception e) {
                Log.w((String)ViewServer.LOG_TAG, (String)"Connection error: ", (Throwable)e);
                return true;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                ViewServer.this.removeWindowListener(this);
            }
        }
    }

    private static class NoopViewServer
    extends ViewServer {
        private NoopViewServer() {
        }

        @Override
        public boolean start() throws IOException {
            return false;
        }

        @Override
        public boolean stop() {
            return false;
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public void addWindow(Activity activity) {
        }

        @Override
        public void removeWindow(Activity activity) {
        }

        @Override
        public void addWindow(View view, String name) {
        }

        @Override
        public void removeWindow(View view) {
        }

        @Override
        public void setFocusedWindow(Activity activity) {
        }

        @Override
        public void setFocusedWindow(View view) {
        }

        @Override
        public void run() {
        }
    }

    private static class UncloseableOutputStream
    extends OutputStream {
        private final OutputStream mStream;

        UncloseableOutputStream(OutputStream stream) {
            this.mStream = stream;
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object o) {
            return this.mStream.equals(o);
        }

        @Override
        public void flush() throws IOException {
            this.mStream.flush();
        }

        public int hashCode() {
            return this.mStream.hashCode();
        }

        public String toString() {
            return this.mStream.toString();
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            this.mStream.write(buffer, offset, count);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.mStream.write(buffer);
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.mStream.write(oneByte);
        }
    }

    private static interface WindowListener {
        public void windowsChanged();

        public void focusChanged();
    }
}

