/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.ISaveAble;
import com.hankcs.hanlp.corpus.dictionary.SimpleDictionary;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.occurrence.TermFrequency;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;

public class TFDictionary
extends SimpleDictionary<TermFrequency>
implements ISaveAble {
    String delimeter;

    public TFDictionary(String delimeter) {
        this.delimeter = delimeter;
    }

    public TFDictionary() {
        this("=");
    }

    @Override
    protected Map.Entry<String, TermFrequency> onGenerateEntry(String line) {
        String[] param = line.split(this.delimeter);
        return new AbstractMap.SimpleEntry<String, TermFrequency>(param[0], new TermFrequency(param[0], Integer.valueOf(param[1])));
    }

    public int combine(TFDictionary dictionary, int limit, boolean add) {
        int preSize = this.trie.size();
        for (Map.Entry entry : dictionary.trie.entrySet()) {
            TermFrequency termFrequency = (TermFrequency)this.trie.get(entry.getKey());
            if (termFrequency == null) {
                this.trie.put(entry.getKey(), new TermFrequency(entry.getKey(), Math.min(limit, (Integer)((TermFrequency)entry.getValue()).getValue())));
                continue;
            }
            if (!add) continue;
            termFrequency.setValue((Integer)termFrequency.getValue() + Math.min(limit, (Integer)((TermFrequency)entry.getValue()).getValue()));
        }
        return this.trie.size() - preSize;
    }

    public static int combine(String[] path) {
        TFDictionary dictionaryMain = new TFDictionary();
        dictionaryMain.load(path[0]);
        int preSize = dictionaryMain.trie.size();
        for (int i = 1; i < path.length; ++i) {
            TFDictionary dictionary = new TFDictionary();
            dictionary.load(path[i]);
            dictionaryMain.combine(dictionary, 1, true);
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path[0])));
            for (Map.Entry entry : dictionaryMain.trie.entrySet()) {
                bw.write(entry.getKey());
                bw.write(32);
                bw.write(String.valueOf(((TermFrequency)entry.getValue()).getValue()));
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return dictionaryMain.trie.size() - preSize;
    }

    public int getFrequency(String key) {
        TermFrequency termFrequency = (TermFrequency)this.get(key);
        if (termFrequency == null) {
            return 0;
        }
        return termFrequency.getFrequency();
    }

    public void add(String key) {
        TermFrequency termFrequency = (TermFrequency)this.trie.get(key);
        if (termFrequency == null) {
            termFrequency = new TermFrequency(key);
            this.trie.put(key, termFrequency);
        } else {
            termFrequency.increase();
        }
    }

    @Override
    public boolean saveTxtTo(String path) {
        if ("=".equals(this.delimeter)) {
            LinkedList termFrequencyLinkedList = new LinkedList();
            for (Map.Entry entry : this.trie.entrySet()) {
                termFrequencyLinkedList.add(entry.getValue());
            }
            return IOUtil.saveCollectionToTxt(termFrequencyLinkedList, path);
        }
        ArrayList<String> outList = new ArrayList<String>(this.size());
        for (Map.Entry entry : this.trie.entrySet()) {
            outList.add(entry.getKey() + this.delimeter + ((TermFrequency)entry.getValue()).getFrequency());
        }
        return IOUtil.saveCollectionToTxt(outList, path);
    }

    public boolean saveKeyTo(String path) {
        LinkedList<String> keyList = new LinkedList<String>();
        for (Map.Entry entry : this.trie.entrySet()) {
            keyList.add(entry.getKey());
        }
        return IOUtil.saveCollectionToTxt(keyList, path);
    }

    public TreeSet<TermFrequency> values() {
        TreeSet<TermFrequency> set = new TreeSet<TermFrequency>(Collections.reverseOrder());
        for (Map.Entry entry : this.entrySet()) {
            set.add((TermFrequency)entry.getValue());
        }
        return set;
    }
}

