/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Other;

import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.other.CharType;
import com.hankcs.hanlp.seg.common.ResultTerm;
import java.util.LinkedList;

public class CommonAhoCorasickSegmentUtil {
    public static <V> LinkedList<ResultTerm<V>> segment(final char[] charArray, AhoCorasickDoubleArrayTrie<V> trie) {
        LinkedList<ResultTerm<V>> termList = new LinkedList<ResultTerm<V>>();
        final ResultTerm[] wordNet = new ResultTerm[charArray.length];
        trie.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<V>(){

            @Override
            public void hit(int begin, int end, V value) {
                if (wordNet[begin] == null || wordNet[begin].word.length() < end - begin) {
                    wordNet[begin] = new ResultTerm(new String(charArray, begin, end - begin), value, begin);
                }
            }
        });
        int i = 0;
        while (i < charArray.length) {
            if (wordNet[i] == null) {
                StringBuilder sbTerm = new StringBuilder();
                int offset = i;
                while (i < charArray.length && wordNet[i] == null) {
                    sbTerm.append(charArray[i]);
                    ++i;
                }
                termList.add(new ResultTerm<Object>(sbTerm.toString(), null, offset));
                continue;
            }
            termList.add(wordNet[i]);
            i += wordNet[i].word.length();
        }
        return termList;
    }

    public static <V> LinkedList<ResultTerm<V>> segmentReverseOrder(final char[] charArray, AhoCorasickDoubleArrayTrie<V> trie) {
        LinkedList<ResultTerm<V>> termList = new LinkedList<ResultTerm<V>>();
        final ResultTerm[] wordNet = new ResultTerm[charArray.length + 1];
        trie.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<V>(){

            @Override
            public void hit(int begin, int end, V value) {
                if (wordNet[end] == null || wordNet[end].word.length() < end - begin) {
                    wordNet[end] = new ResultTerm(new String(charArray, begin, end - begin), value, begin);
                }
            }
        });
        int i = charArray.length;
        while (i > 0) {
            if (wordNet[i] == null) {
                StringBuilder sbTerm = new StringBuilder();
                int offset = i - 1;
                byte preCharType = CharType.get(charArray[offset]);
                while (i > 0 && wordNet[i] == null && CharType.get(charArray[i - 1]) == preCharType) {
                    sbTerm.append(charArray[i - 1]);
                    preCharType = CharType.get(charArray[i - 1]);
                    --i;
                }
                termList.addFirst(new ResultTerm<Object>(sbTerm.reverse().toString(), null, offset));
                continue;
            }
            termList.addFirst(wordNet[i]);
            i -= wordNet[i].word.length();
        }
        return termList;
    }
}

