/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone;

import com.hankcs.hanlp.collection.dartsclone.Pair;
import com.hankcs.hanlp.collection.dartsclone.details.DoubleArrayBuilder;
import com.hankcs.hanlp.collection.dartsclone.details.Keyset;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DoubleArray {
    static Charset utf8 = Charset.forName("UTF-8");
    private static final int UNIT_SIZE = 4;
    private int[] _array;

    public void build(byte[][] keys, int[] values) {
        Keyset keyset = new Keyset(keys, values);
        DoubleArrayBuilder builder = new DoubleArrayBuilder();
        builder.build(keyset);
        this._array = builder.copy();
    }

    public void build(List<String> keys, int[] values) {
        byte[][] byteKey = new byte[keys.size()][];
        Iterator<String> iteratorKey = keys.iterator();
        int i = 0;
        while (iteratorKey.hasNext()) {
            byteKey[i] = iteratorKey.next().getBytes(utf8);
            ++i;
        }
        this.build(byteKey, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(InputStream stream) throws IOException {
        int size = stream.available() / 4;
        this._array = new int[size];
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(stream));
            for (int i = 0; i < size; ++i) {
                this._array[i] = ((DataInputStream)in).readInt();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream stream) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(stream));
            for (int i = 0; i < this._array.length; ++i) {
                ((DataOutputStream)out).writeInt(this._array[i]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public int exactMatchSearch(String key) {
        return this.exactMatchSearch(key.getBytes(utf8));
    }

    public int exactMatchSearch(byte[] key) {
        int unit = this._array[0];
        int nodePos = 0;
        for (byte b : key) {
            if (((unit = this._array[nodePos ^= unit >>> 10 << ((unit & 0x200) >>> 6) ^ b & 0xFF]) & 0x800000FF) == (b & 0xFF)) continue;
            return -1;
        }
        if ((unit >>> 8 & 1) != 1) {
            return -1;
        }
        unit = this._array[nodePos ^ unit >>> 10 << ((unit & 0x200) >>> 6)];
        return unit & Integer.MAX_VALUE;
    }

    public List<Pair<Integer, Integer>> commonPrefixSearch(byte[] key, int offset, int maxResults) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        int unit = this._array[0];
        int nodePos = 0;
        nodePos ^= unit >>> 10 << ((unit & 0x200) >>> 6);
        for (int i = offset; i < key.length; ++i) {
            byte b = key[i];
            unit = this._array[nodePos ^= b & 0xFF];
            if ((unit & 0x800000FF) != (b & 0xFF)) {
                return result;
            }
            nodePos ^= unit >>> 10 << ((unit & 0x200) >>> 6);
            if ((unit >>> 8 & 1) != 1 || result.size() >= maxResults) continue;
            result.add(new Pair<Integer, Integer>(i + 1, this._array[nodePos] & Integer.MAX_VALUE));
        }
        return result;
    }

    public int size() {
        return this._array.length;
    }
}

