/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.trie.bintrie;

import com.hankcs.hanlp.collection.trie.bintrie.BaseNode;
import com.hankcs.hanlp.collection.trie.bintrie.util.ArrayTool;

public class Node<V>
extends BaseNode {
    @Override
    protected boolean addChild(BaseNode node) {
        int index;
        boolean add = false;
        if (this.child == null) {
            this.child = new BaseNode[0];
        }
        if ((index = ArrayTool.binarySearch(this.child, node)) >= 0) {
            BaseNode target = this.child[index];
            switch (node.status) {
                case UNDEFINED_0: {
                    if (target.status == BaseNode.Status.NOT_WORD_1) break;
                    target.status = BaseNode.Status.NOT_WORD_1;
                    add = true;
                    break;
                }
                case NOT_WORD_1: {
                    if (target.status != BaseNode.Status.WORD_END_3) break;
                    target.status = BaseNode.Status.WORD_MIDDLE_2;
                    break;
                }
                case WORD_END_3: {
                    if (target.status != BaseNode.Status.WORD_END_3) {
                        target.status = BaseNode.Status.WORD_MIDDLE_2;
                    }
                    if (target.getValue() == null) {
                        add = true;
                    }
                    target.setValue(node.getValue());
                }
            }
        } else {
            BaseNode[] newChild = new BaseNode[this.child.length + 1];
            int insert = -(index + 1);
            System.arraycopy(this.child, 0, newChild, 0, insert);
            System.arraycopy(this.child, insert, newChild, insert + 1, this.child.length - insert);
            newChild[insert] = node;
            this.child = newChild;
            add = true;
        }
        return add;
    }

    public Node(char c, BaseNode.Status status, V value) {
        this.c = c;
        this.status = status;
        this.value = value;
    }

    public Node() {
    }

    @Override
    public BaseNode getChild(char c) {
        if (this.child == null) {
            return null;
        }
        int index = ArrayTool.binarySearch(this.child, c);
        if (index < 0) {
            return null;
        }
        return this.child[index];
    }
}

