/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.synonym.Synonym;
import com.hankcs.hanlp.corpus.synonym.SynonymHelper;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class CommonSynonymDictionary {
    DoubleArrayTrie<SynonymItem> trie;
    private long maxSynonymItemIdDistance;

    private CommonSynonymDictionary() {
    }

    public static CommonSynonymDictionary create(InputStream inputStream) {
        CommonSynonymDictionary dictionary = new CommonSynonymDictionary();
        if (dictionary.load(inputStream)) {
            return dictionary;
        }
        return null;
    }

    public boolean load(InputStream inputStream) {
        this.trie = new DoubleArrayTrie();
        TreeMap<String, SynonymItem> treeMap = new TreeMap<String, SynonymItem>();
        String line = null;
        try {
            int resultCode;
            BufferedReader bw = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList<Synonym> synonymList = null;
            while ((line = bw.readLine()) != null) {
                String[] args = line.split(" ");
                synonymList = Synonym.create(args);
                char type = args[0].charAt(args[0].length() - 1);
                for (Synonym synonym : synonymList) {
                    treeMap.put(synonym.realWord, new SynonymItem(synonym, synonymList, type));
                }
            }
            bw.close();
            if (synonymList != null && synonymList.size() > 0) {
                this.maxSynonymItemIdDistance = synonymList.get((int)(synonymList.size() - 1)).id - SynonymHelper.convertString2IdWithIndex("Aa01A01", 0) + 1L;
            }
            if ((resultCode = this.trie.build(treeMap)) != 0) {
                Predefine.logger.warning("\u6784\u5efa" + inputStream + "\u5931\u8d25\uff0c\u9519\u8bef\u7801" + resultCode);
                return false;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + inputStream + "\u5931\u8d25\uff0c\u53ef\u80fd\u7531\u884c" + line + "\u9020\u6210");
            return false;
        }
        return true;
    }

    public SynonymItem get(String key) {
        return this.trie.get(key);
    }

    public long getMaxSynonymItemIdDistance() {
        return this.maxSynonymItemIdDistance;
    }

    public long distance(String a, String b) {
        SynonymItem itemA = this.get(a);
        if (itemA == null) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        SynonymItem itemB = this.get(b);
        if (itemB == null) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        return itemA.distance(itemB);
    }

    public static class SynonymItem {
        public Synonym entry;
        public List<Synonym> synonymList;
        public Type type;

        public SynonymItem(Synonym entry, List<Synonym> synonymList, Type type) {
            this.entry = entry;
            this.synonymList = synonymList;
            this.type = type;
        }

        public SynonymItem(Synonym entry, List<Synonym> synonymList, char type) {
            this.entry = entry;
            this.synonymList = synonymList;
            switch (type) {
                case '=': {
                    this.type = Type.EQUAL;
                    break;
                }
                case '#': {
                    this.type = Type.LIKE;
                    break;
                }
                default: {
                    this.type = Type.SINGLE;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.entry);
            sb.append(' ');
            sb.append((Object)this.type);
            sb.append(' ');
            sb.append(this.synonymList);
            return sb.toString();
        }

        public long distance(SynonymItem other) {
            return this.entry.distance(other.entry);
        }

        public static SynonymItem createUndefined(String word) {
            SynonymItem item = new SynonymItem(new Synonym(word, (long)(word.hashCode() * 1000000) + 0x2AAAAAAAAAAAAAAAL), null, Type.UNDEFINED);
            return item;
        }

        public static enum Type {
            EQUAL,
            LIKE,
            SINGLE,
            UNDEFINED;

        }
    }
}

