/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.dictionary.StringDictionary;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.utility.Predefine;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BaseChineseDictionary {
    static boolean load(String path, AhoCorasickDoubleArrayTrie<String> trie) {
        return BaseChineseDictionary.load(path, trie, false);
    }

    static boolean load(String path, AhoCorasickDoubleArrayTrie<String> trie, boolean reverse) {
        String datPath = path;
        if (reverse) {
            datPath = datPath + ".reverse";
        }
        if (BaseChineseDictionary.loadDat(datPath, trie)) {
            return true;
        }
        StringDictionary dictionary = new StringDictionary("=");
        if (!dictionary.load(path)) {
            return false;
        }
        if (reverse) {
            dictionary = dictionary.reverse();
        }
        Set<Map.Entry<String, String>> entrySet = dictionary.entrySet();
        TreeMap map = new TreeMap();
        for (Map.Entry entry : entrySet) {
            map.put(entry.getKey(), entry.getValue());
        }
        Predefine.logger.info("\u6b63\u5728\u6784\u5efaAhoCorasickDoubleArrayTrie\uff0c\u6765\u6e90\uff1a" + path);
        trie.build(map);
        Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u53cc\u6570\u7ec4" + datPath);
        BaseChineseDictionary.saveDat(datPath, trie, entrySet);
        return true;
    }

    static boolean loadDat(String path, AhoCorasickDoubleArrayTrie<String> trie) {
        ByteArray byteArray = ByteArray.createByteArray(path + ".bin");
        if (byteArray == null) {
            return false;
        }
        int size = byteArray.nextInt();
        String[] valueArray = new String[size];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = byteArray.nextString();
        }
        trie.load(byteArray, (String[])valueArray);
        return true;
    }

    static boolean saveDat(String path, AhoCorasickDoubleArrayTrie<String> trie, Set<Map.Entry<String, String>> entrySet) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(path + ".bin"));
            out.writeInt(entrySet.size());
            for (Map.Entry<String, String> entry : entrySet) {
                char[] charArray = entry.getValue().toCharArray();
                out.writeInt(charArray.length);
                for (char c : charArray) {
                    out.writeChar(c);
                }
            }
            trie.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u7f13\u5b58\u503cdat" + path + "\u5931\u8d25");
            return false;
        }
        return true;
    }

    public static BaseSearcher getSearcher(char[] charArray, DoubleArrayTrie<String> trie) {
        return new Searcher(charArray, trie);
    }

    protected static String segLongest(char[] charArray, DoubleArrayTrie<String> trie) {
        Map.Entry entry;
        StringBuilder sb = new StringBuilder(charArray.length);
        BaseSearcher searcher = BaseChineseDictionary.getSearcher(charArray, trie);
        int p = 0;
        while ((entry = searcher.next()) != null) {
            int offset = searcher.getOffset();
            while (p < offset) {
                sb.append(charArray[p]);
                ++p;
            }
            sb.append((String)entry.getValue());
            p = offset + entry.getKey().length();
        }
        while (p < charArray.length) {
            sb.append(charArray[p]);
            ++p;
        }
        return sb.toString();
    }

    protected static String segLongest(char[] charArray, AhoCorasickDoubleArrayTrie<String> trie) {
        final String[] wordNet = new String[charArray.length];
        final int[] lengthNet = new int[charArray.length];
        trie.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<String>(){

            @Override
            public void hit(int begin, int end, String value) {
                int length = end - begin;
                if (length > lengthNet[begin]) {
                    wordNet[begin] = value;
                    lengthNet[begin] = length;
                }
            }
        });
        StringBuilder sb = new StringBuilder(charArray.length);
        int offset = 0;
        while (offset < wordNet.length) {
            if (wordNet[offset] == null) {
                sb.append(charArray[offset]);
                ++offset;
                continue;
            }
            sb.append(wordNet[offset]);
            offset += lengthNet[offset];
        }
        return sb.toString();
    }

    public static class Searcher
    extends BaseSearcher<String> {
        int begin;
        DoubleArrayTrie<String> trie;

        protected Searcher(char[] c, DoubleArrayTrie<String> trie) {
            super(c);
            this.trie = trie;
        }

        protected Searcher(String text, DoubleArrayTrie<String> trie) {
            super(text);
            this.trie = trie;
        }

        @Override
        public Map.Entry<String, String> next() {
            Map.Entry<String, String> result = null;
            while (this.begin < this.c.length) {
                LinkedList<Map.Entry<String, String>> entryList = this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                if (entryList.size() == 0) {
                    ++this.begin;
                    continue;
                }
                result = entryList.getLast();
                this.offset = this.begin;
                this.begin += result.getKey().length();
                break;
            }
            if (result == null) {
                return null;
            }
            return result;
        }
    }
}

