/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class CoreBiGramTableDictionary {
    static int[] start;
    static int[] pair;

    static boolean load(String path) {
        String datPath = HanLP.Config.BiGramDictionaryPath + ".table" + ".bin";
        if (CoreBiGramTableDictionary.loadDat(datPath)) {
            return true;
        }
        TreeMap<Integer, TreeMap<Integer, Integer>> map = new TreeMap<Integer, TreeMap<Integer, Integer>>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            int total = 0;
            int maxWordId = CoreDictionary.trie.size();
            while ((line = br.readLine()) != null) {
                String b;
                int idB;
                String[] params = line.split("\\s");
                String[] twoWord = params[0].split("@", 2);
                String a = twoWord[0];
                int idA = CoreDictionary.trie.exactMatchSearch(a);
                if (idA == -1 || (idB = CoreDictionary.trie.exactMatchSearch(b = twoWord[1])) == -1) continue;
                int freq = Integer.parseInt(params[1]);
                TreeMap<Integer, Integer> biMap = (TreeMap<Integer, Integer>)map.get(idA);
                if (biMap == null) {
                    biMap = new TreeMap<Integer, Integer>();
                    map.put(idA, biMap);
                }
                biMap.put(idB, freq);
                total += 2;
            }
            br.close();
            start = new int[maxWordId + 1];
            pair = new int[total];
            int offset = 0;
            for (int i = 0; i < maxWordId; ++i) {
                TreeMap bMap = (TreeMap)map.get(i);
                if (bMap != null) {
                    for (Map.Entry entry : bMap.entrySet()) {
                        int index = offset << 1;
                        CoreBiGramTableDictionary.pair[index] = (Integer)entry.getKey();
                        CoreBiGramTableDictionary.pair[index + 1] = (Integer)entry.getValue();
                        ++offset;
                    }
                }
                CoreBiGramTableDictionary.start[i + 1] = offset;
            }
            Predefine.logger.info("\u4e8c\u5143\u8bcd\u5178\u8bfb\u53d6\u5b8c\u6bd5:" + path + "\uff0c\u6784\u5efa\u4e3aTableBin\u7ed3\u6784");
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178" + path + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        Predefine.logger.info("\u5f00\u59cb\u7f13\u5b58\u4e8c\u5143\u8bcd\u5178\u5230" + datPath);
        if (!CoreBiGramTableDictionary.saveDat(datPath)) {
            Predefine.logger.warning("\u7f13\u5b58\u4e8c\u5143\u8bcd\u5178\u5230" + datPath + "\u5931\u8d25");
        }
        return true;
    }

    static boolean saveDat(String path) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(IOUtil.newOutputStream(path));
            out.writeObject(start);
            out.writeObject(pair);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.log(Level.WARNING, "\u5728\u7f13\u5b58" + path + "\u65f6\u53d1\u751f\u5f02\u5e38", e);
            return false;
        }
        return true;
    }

    static boolean loadDat(String path) {
        try {
            ObjectInputStream in = new ObjectInputStream(IOUtil.newInputStream(path));
            start = (int[])in.readObject();
            if (CoreDictionary.trie.size() != start.length - 1) {
                in.close();
                return false;
            }
            pair = (int[])in.readObject();
            in.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5c1d\u8bd5\u8f7d\u5165\u7f13\u5b58\u6587\u4ef6" + path + "\u53d1\u751f\u5f02\u5e38[" + e + "]\uff0c\u4e0b\u9762\u5c06\u8f7d\u5165\u6e90\u6587\u4ef6\u5e76\u81ea\u52a8\u7f13\u5b58\u2026\u2026");
            return false;
        }
        return true;
    }

    private static int binarySearch(int[] a, int fromIndex, int length, int key) {
        int low = fromIndex;
        int high = fromIndex + length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid << 1];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int getBiFrequency(String a, String b) {
        int idA = CoreDictionary.trie.exactMatchSearch(a);
        if (idA == -1) {
            return 0;
        }
        int idB = CoreDictionary.trie.exactMatchSearch(b);
        if (idB == -1) {
            return 0;
        }
        int index = CoreBiGramTableDictionary.binarySearch(pair, start[idA], start[idA + 1] - start[idA], idB);
        if (index < 0) {
            return 0;
        }
        return pair[(index <<= 1) + 1];
    }

    public static int getBiFrequency(int idA, int idB) {
        if (idA < 0) {
            return -idA;
        }
        if (idB < 0) {
            return -idB;
        }
        int index = CoreBiGramTableDictionary.binarySearch(pair, start[idA], start[idA + 1] - start[idA], idB);
        if (index < 0) {
            return 0;
        }
        return pair[(index <<= 1) + 1];
    }

    public static int getWordID(String a) {
        return CoreDictionary.trie.exactMatchSearch(a);
    }

    public static boolean reload() {
        String biGramDictionaryPath = HanLP.Config.BiGramDictionaryPath;
        IOUtil.deleteFile(biGramDictionaryPath + ".table" + ".bin");
        return CoreBiGramTableDictionary.load(biGramDictionaryPath);
    }

    static {
        String path = HanLP.Config.BiGramDictionaryPath;
        Predefine.logger.info("\u5f00\u59cb\u52a0\u8f7d\u4e8c\u5143\u8bcd\u5178" + path + ".table");
        long start = System.currentTimeMillis();
        if (!CoreBiGramTableDictionary.load(path)) {
            throw new IllegalArgumentException("\u4e8c\u5143\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info(path + ".table" + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

