/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.crf.CRFTagger;
import com.hankcs.hanlp.model.crf.crfpp.TaggerImpl;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;

public class CRFNERecognizer
extends CRFTagger
implements NERecognizer {
    private NERTagSet tagSet = new NERTagSet();

    public CRFNERecognizer() throws IOException {
        this(HanLP.Config.CRFNERModelPath);
    }

    public CRFNERecognizer(String modelPath) throws IOException {
        super(modelPath);
        if (this.model != null) {
            for (String y : this.model.getFeatureIndex_().getY_()) {
                String label = NERTagSet.posOf(y);
                if (label.length() == y.length()) continue;
                this.tagSet.nerLabels.add(label);
            }
        } else {
            this.addDefaultNERLabels();
        }
    }

    protected void addDefaultNERLabels() {
        this.tagSet.nerLabels.add("nr");
        this.tagSet.nerLabels.add("ns");
        this.tagSet.nerLabels.add("nt");
    }

    @Override
    protected void convertCorpus(Sentence sentence, BufferedWriter bw) throws IOException {
        List<String[]> collector = Utility.convertSentenceToNER(sentence, this.tagSet);
        for (String[] tuple : collector) {
            bw.write(tuple[0]);
            bw.write(9);
            bw.write(tuple[1]);
            bw.write(9);
            bw.write(tuple[2]);
            bw.newLine();
        }
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        TaggerImpl tagger = this.createTagger();
        for (int i = 0; i < wordArray.length; ++i) {
            tagger.add(new String[]{wordArray[i], posArray[i]});
        }
        tagger.parse();
        String[] tagArray = new String[wordArray.length];
        for (int i = 0; i < tagArray.length; ++i) {
            tagArray[i] = tagger.yname(tagger.y(i));
        }
        return tagArray;
    }

    @Override
    public NERTagSet getNERTagSet() {
        return this.tagSet;
    }

    @Override
    protected String getDefaultFeatureTemplate() {
        return "# Unigram\nU0:%x[-2,0]\nU1:%x[-1,0]\nU2:%x[0,0]\nU3:%x[1,0]\nU4:%x[2,0]\nU5:%x[-2,1]\nU6:%x[-1,1]\nU7:%x[0,1]\nU8:%x[1,1]\nU9:%x[2,1]\nUA:%x[-2,1]%x[-1,1]\nUB:%x[-1,1]%x[0,1]\nUC:%x[0,1]%x[1,1]\nUD:%x[1,1]%x[2,1]\nUE:%x[2,1]%x[3,1]\n\n# Bigram\nB";
    }
}

