/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.hmm;

import com.hankcs.hanlp.model.hmm.HiddenMarkovModel;
import java.util.Collection;

public class SecondOrderHiddenMarkovModel
extends HiddenMarkovModel {
    float[][][] transition_probability2;

    private SecondOrderHiddenMarkovModel(float[] start_probability, float[][] transition_probability, float[][] emission_probability) {
        super(start_probability, transition_probability, emission_probability);
    }

    public SecondOrderHiddenMarkovModel(float[] start_probability, float[][] transition_probability, float[][] emission_probability, float[][][] transition_probability2) {
        this(start_probability, transition_probability, emission_probability);
        this.transition_probability2 = transition_probability2;
        this.toLog();
    }

    public SecondOrderHiddenMarkovModel() {
        this(null, null, null, null);
    }

    @Override
    protected void estimateTransitionProbability(Collection<int[][]> samples, int max_state) {
        this.transition_probability = new float[max_state + 1][max_state + 1];
        this.transition_probability2 = new float[max_state + 1][max_state + 1][max_state + 1];
        for (int[][] sample : samples) {
            int prev_s = sample[1][0];
            int prev_prev_s = -1;
            for (int i = 1; i < sample[0].length; ++i) {
                int s = sample[1][i];
                if (i == 1) {
                    float[] fArray = this.transition_probability[prev_s];
                    int n = s;
                    fArray[n] = fArray[n] + 1.0f;
                } else {
                    float[] fArray = this.transition_probability2[prev_prev_s][prev_s];
                    int n = s;
                    fArray[n] = fArray[n] + 1.0f;
                }
                prev_prev_s = prev_s;
                prev_s = s;
            }
        }
        for (Object p : (Object)this.transition_probability) {
            this.normalize((float[])p);
        }
        Object object = this.transition_probability2;
        int n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            Object pp;
            for (Object p : pp = object[i]) {
                this.normalize((float[])p);
            }
        }
    }

    @Override
    public int[][] generate(int length) {
        double[] pi = SecondOrderHiddenMarkovModel.logToCdf(this.start_probability);
        double[][] A = SecondOrderHiddenMarkovModel.logToCdf(this.transition_probability);
        double[][][] A2 = this.logToCdf(this.transition_probability2);
        double[][] B = SecondOrderHiddenMarkovModel.logToCdf(this.emission_probability);
        int[][] os = new int[2][length];
        os[1][0] = SecondOrderHiddenMarkovModel.drawFrom(pi);
        os[0][0] = SecondOrderHiddenMarkovModel.drawFrom(B[os[1][0]]);
        os[1][1] = SecondOrderHiddenMarkovModel.drawFrom(A[os[1][0]]);
        os[0][1] = SecondOrderHiddenMarkovModel.drawFrom(B[os[1][1]]);
        for (int t = 2; t < length; ++t) {
            os[1][t] = SecondOrderHiddenMarkovModel.drawFrom(A2[os[1][t - 2]][os[1][t - 1]]);
            os[0][t] = SecondOrderHiddenMarkovModel.drawFrom(B[os[1][t]]);
        }
        return os;
    }

    private double[][][] logToCdf(float[][][] log) {
        double[][][] cdf = new double[log.length][log[0].length][log[0][0].length];
        for (int i = 0; i < log.length; ++i) {
            cdf[i] = SecondOrderHiddenMarkovModel.logToCdf(log[i]);
        }
        return cdf;
    }

    @Override
    protected void toLog() {
        super.toLog();
        if (this.transition_probability2 != null) {
            float[][][] fArray = this.transition_probability2;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                float[][] m;
                for (float[] v : m = fArray[i]) {
                    for (int i2 = 0; i2 < v.length; ++i2) {
                        v[i2] = (float)Math.log(v[i2]);
                    }
                }
            }
        }
    }

    @Override
    public float predict(int[] observation, int[] state) {
        int time = observation.length;
        int max_s = this.start_probability.length;
        float[][] score = new float[max_s][max_s];
        float[] first = new float[max_s];
        int[][][] link = new int[time][max_s][max_s];
        for (int cur_s = 0; cur_s < max_s; ++cur_s) {
            first[cur_s] = this.start_probability[cur_s] + this.emission_probability[cur_s][observation[0]];
        }
        if (time == 1) {
            int best_s = -1;
            float max_score = -2.1474836E9f;
            for (int cur_s = 0; cur_s < max_s; ++cur_s) {
                if (!(first[cur_s] > max_score)) continue;
                best_s = cur_s;
                max_score = first[cur_s];
            }
            state[0] = best_s;
            return max_score;
        }
        for (int f = 0; f < max_s; ++f) {
            for (int s = 0; s < max_s; ++s) {
                float p;
                score[f][s] = p = first[f] + this.transition_probability[f][s] + this.emission_probability[s][observation[1]];
                link[1][f][s] = f;
            }
        }
        float[][] pre = new float[max_s][max_s];
        for (int i = 2; i < observation.length; ++i) {
            float[][] _ = pre;
            pre = score;
            score = _;
            for (int s = 0; s < max_s; ++s) {
                for (int t = 0; t < max_s; ++t) {
                    score[s][t] = -2.1474836E9f;
                    for (int f = 0; f < max_s; ++f) {
                        float p = pre[f][s] + this.transition_probability2[f][s][t] + this.emission_probability[t][observation[i]];
                        if (!(p > score[s][t])) continue;
                        score[s][t] = p;
                        link[i][s][t] = f;
                    }
                }
            }
        }
        float max_score = -2.1474836E9f;
        int best_s = 0;
        int best_t = 0;
        for (int s = 0; s < max_s; ++s) {
            for (int t = 0; t < max_s; ++t) {
                if (!(score[s][t] > max_score)) continue;
                max_score = score[s][t];
                best_s = s;
                best_t = t;
            }
        }
        for (int i = link.length - 1; i >= 0; --i) {
            state[i] = best_t;
            int best_f = link[i][best_s][best_t];
            best_t = best_s;
            best_s = best_f;
        }
        return max_score;
    }

    @Override
    public void unLog() {
        super.unLog();
        float[][][] fArray = this.transition_probability2;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[][] m;
            for (float[] v : m = fArray[i]) {
                for (int i2 = 0; i2 < v.length; ++i2) {
                    v[i2] = (float)Math.exp(v[i2]);
                }
            }
        }
    }

    @Override
    public boolean similar(HiddenMarkovModel model) {
        if (!(model instanceof SecondOrderHiddenMarkovModel)) {
            return false;
        }
        SecondOrderHiddenMarkovModel hmm2 = (SecondOrderHiddenMarkovModel)model;
        for (int i = 0; i < this.transition_probability.length; ++i) {
            for (int j = 0; j < this.transition_probability.length; ++j) {
                if (SecondOrderHiddenMarkovModel.similar(this.transition_probability2[i][j], hmm2.transition_probability2[i][j])) continue;
                return false;
            }
        }
        return super.similar(model);
    }
}

