/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.common;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.utility.MathUtility;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class WordNet {
    private LinkedList<Vertex>[] vertexes;
    int size;
    public String sentence;
    public char[] charArray;

    public WordNet(String sentence) {
        this(sentence.toCharArray());
    }

    public WordNet(char[] charArray) {
        this.charArray = charArray;
        this.vertexes = new LinkedList[charArray.length + 2];
        for (int i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i] = new LinkedList();
        }
        this.vertexes[0].add(Vertex.newB());
        this.vertexes[this.vertexes.length - 1].add(Vertex.newE());
        this.size = 2;
    }

    public WordNet(char[] charArray, List<Vertex> vertexList) {
        int i;
        this.charArray = charArray;
        this.vertexes = new LinkedList[charArray.length + 2];
        for (i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i] = new LinkedList();
        }
        i = 0;
        for (Vertex vertex : vertexList) {
            this.vertexes[i].add(vertex);
            ++this.size;
            i += vertex.realWord.length();
        }
    }

    public void add(int line, Vertex vertex) {
        for (Vertex oldVertex : this.vertexes[line]) {
            if (oldVertex.realWord.length() != vertex.realWord.length()) continue;
            return;
        }
        this.vertexes[line].add(vertex);
        ++this.size;
    }

    public void push(int line, Vertex vertex) {
        Iterator iterator = this.vertexes[line].iterator();
        while (iterator.hasNext()) {
            if (((Vertex)iterator.next()).realWord.length() != vertex.realWord.length()) continue;
            iterator.remove();
            --this.size;
            break;
        }
        this.vertexes[line].add(vertex);
        ++this.size;
    }

    public void insert(int line, Vertex vertex, WordNet wordNetAll) {
        Vertex first;
        int l;
        for (Vertex oldVertex : this.vertexes[line]) {
            if (oldVertex.realWord.length() != vertex.realWord.length()) continue;
            return;
        }
        this.vertexes[line].add(vertex);
        ++this.size;
        for (l = line - 1; l > 1 && this.get(l, 1) == null && (first = wordNetAll.getFirst(l)) != null; --l) {
            this.vertexes[l].add(first);
            ++this.size;
            if (this.vertexes[l].size() > 1) break;
        }
        if (this.get(l = line + vertex.realWord.length()).size() == 0) {
            List<Vertex> targetLine = wordNetAll.get(l);
            if (targetLine == null || targetLine.size() == 0) {
                return;
            }
            this.vertexes[l].addAll(targetLine);
            this.size += targetLine.size();
        }
        ++l;
        while (l < this.vertexes.length && this.get(l).size() == 0 && (first = wordNetAll.getFirst(l)) != null) {
            this.vertexes[l].add(first);
            ++this.size;
            if (this.vertexes[l].size() > 1) break;
            ++l;
        }
    }

    public void addAll(List<Vertex> vertexList) {
        int i = 0;
        for (Vertex vertex : vertexList) {
            this.add(i, vertex);
            i += vertex.realWord.length();
        }
    }

    public List<Vertex> get(int line) {
        return this.vertexes[line];
    }

    public Iterator<Vertex> descendingIterator(int line) {
        return this.vertexes[line].descendingIterator();
    }

    public Vertex getFirst(int line) {
        Iterator iterator = this.vertexes[line].iterator();
        if (iterator.hasNext()) {
            return (Vertex)iterator.next();
        }
        return null;
    }

    public Vertex get(int line, int length) {
        for (Vertex vertex : this.vertexes[line]) {
            if (vertex.realWord.length() != length) continue;
            return vertex;
        }
        return null;
    }

    public void add(int line, List<AtomNode> atomSegment) {
        int offset = 0;
        for (AtomNode atomNode : atomSegment) {
            String sWord = atomNode.sWord;
            Nature nature = Nature.n;
            int id = -1;
            switch (atomNode.nPOS) {
                case 7: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    nature = Nature.m;
                    sWord = "\u672a##\u6570";
                    id = CoreDictionary.M_WORD_ID;
                    break;
                }
                case 6: 
                case 17: {
                    nature = Nature.w;
                    break;
                }
                case 5: {
                    nature = Nature.nx;
                    sWord = "\u672a##\u4e32";
                    id = CoreDictionary.X_WORD_ID;
                    break;
                }
            }
            this.add(line + offset, new Vertex(sWord, atomNode.sWord, new CoreDictionary.Attribute(nature, 10000), id));
            offset += atomNode.sWord.length();
        }
    }

    public int size() {
        return this.size;
    }

    private Vertex[] getVertexesLineFirst() {
        Vertex[] vertexes = new Vertex[this.size];
        int i = 0;
        for (LinkedList<Vertex> vertexList : this.vertexes) {
            for (Vertex v : vertexList) {
                v.index = i;
                vertexes[i++] = v;
            }
        }
        return vertexes;
    }

    public Graph toGraph() {
        Graph graph = new Graph(this.getVertexesLineFirst());
        for (int row = 0; row < this.vertexes.length - 1; ++row) {
            LinkedList<Vertex> vertexListFrom = this.vertexes[row];
            for (Vertex from : vertexListFrom) {
                assert (from.realWord.length() > 0) : "\u7a7a\u8282\u70b9\u4f1a\u5bfc\u81f4\u6b7b\u5faa\u73af\uff01";
                int toIndex = row + from.realWord.length();
                for (Vertex to : this.vertexes[toIndex]) {
                    graph.connect(from.index, to.index, MathUtility.calculateWeight(from, to));
                }
            }
        }
        return graph;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int line = 0;
        for (LinkedList<Vertex> vertexList : this.vertexes) {
            sb.append(String.valueOf(line++) + ':' + ((Object)vertexList).toString()).append("\n");
        }
        return sb.toString();
    }

    public void mergeContinuousNsIntoOne() {
        for (int row = 0; row < this.vertexes.length - 1; ++row) {
            LinkedList<Vertex> vertexListFrom = this.vertexes[row];
            ListIterator<Vertex> listIteratorFrom = vertexListFrom.listIterator();
            block1: while (listIteratorFrom.hasNext()) {
                Vertex from = (Vertex)listIteratorFrom.next();
                if (from.getNature() != Nature.ns) continue;
                int toIndex = row + from.realWord.length();
                ListIterator listIteratorTo = this.vertexes[toIndex].listIterator();
                while (listIteratorTo.hasNext()) {
                    Vertex to = (Vertex)listIteratorTo.next();
                    if (to.getNature() != Nature.ns) continue;
                    Predefine.logger.info("\u5408\u5e76\u3010" + from.realWord + "\u3011\u548c\u3010" + to.realWord + "\u3011");
                    listIteratorFrom.set(Vertex.newAddressInstance(from.realWord + to.realWord));
                    continue block1;
                }
            }
        }
    }

    public void clear() {
        for (LinkedList<Vertex> vertexList : this.vertexes) {
            vertexList.clear();
        }
        this.size = 0;
    }

    public void clean() {
        for (LinkedList<Vertex> vertexList : this.vertexes) {
            for (Vertex vertex : vertexList) {
                vertex.from = null;
            }
        }
    }

    public LinkedList<Vertex>[] getVertexes() {
        return this.vertexes;
    }
}

