/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.document.sentence;

import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.document.sentence.word.WordFactory;
import com.hankcs.hanlp.dictionary.other.PartOfSpeechTagDictionary;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import com.hankcs.hanlp.utility.Predefine;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sentence
implements Serializable,
Iterable<IWord> {
    public List<IWord> wordList;

    public Sentence(List<IWord> wordList) {
        this.wordList = wordList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size() * 4);
        int i = 1;
        for (IWord word : this.wordList) {
            sb.append(word);
            if (i != this.wordList.size()) {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public String toStringWithoutLabels() {
        StringBuilder sb = new StringBuilder(this.size() * 4);
        int i = 1;
        for (IWord word : this.wordList) {
            if (word instanceof CompoundWord) {
                int j = 0;
                for (Word w : ((CompoundWord)word).innerList) {
                    sb.append(w.getValue());
                    if (++j == ((CompoundWord)word).innerList.size()) continue;
                    sb.append(' ');
                }
            } else {
                sb.append(word.getValue());
            }
            if (i != this.wordList.size()) {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public String toStandoff() {
        return this.toStandoff(false);
    }

    public String toStandoff(boolean withComment) {
        StringBuilder sb = new StringBuilder(this.size() * 4);
        String delimiter = " ";
        String text = this.text(delimiter);
        sb.append(text).append('\n');
        int i = 1;
        int offset = 0;
        for (IWord word : this.wordList) {
            assert (text.charAt(offset) == word.getValue().charAt(0));
            this.printWord(word, sb, i, offset, withComment);
            ++i;
            if (word instanceof CompoundWord) {
                int offsetChild = offset;
                for (Word child : ((CompoundWord)word).innerList) {
                    this.printWord(child, sb, i, offsetChild, withComment);
                    offsetChild += child.length();
                    offsetChild += delimiter.length();
                    ++i;
                }
                offset += delimiter.length() * ((CompoundWord)word).innerList.size();
            } else {
                offset += delimiter.length();
            }
            offset += word.length();
        }
        return sb.toString();
    }

    public Sentence translateLabels() {
        for (IWord word : this.wordList) {
            word.setLabel(PartOfSpeechTagDictionary.translate(word.getLabel()));
            if (!(word instanceof CompoundWord)) continue;
            for (Word child : ((CompoundWord)word).innerList) {
                child.setLabel(PartOfSpeechTagDictionary.translate(child.getLabel()));
            }
        }
        return this;
    }

    public Sentence translateCompoundWordLabels() {
        for (IWord word : this.wordList) {
            if (!(word instanceof CompoundWord)) continue;
            word.setLabel(PartOfSpeechTagDictionary.translate(word.getLabel()));
        }
        return this;
    }

    private void printWord(IWord word, StringBuilder sb, int id, int offset) {
        this.printWord(word, sb, id, offset, false);
    }

    private void printWord(IWord word, StringBuilder sb, int id, int offset, boolean withComment) {
        char delimiter = '\t';
        char endLine = '\n';
        sb.append('T').append(id).append(delimiter);
        sb.append(word.getLabel()).append(delimiter);
        int length = word.length();
        if (word instanceof CompoundWord) {
            length += ((CompoundWord)word).innerList.size() - 1;
        }
        sb.append(offset).append(delimiter).append(offset + length).append(delimiter);
        sb.append(word.getValue()).append(endLine);
        String translated = PartOfSpeechTagDictionary.translate(word.getLabel());
        if (withComment && !word.getLabel().equals(translated)) {
            sb.append('#').append(id).append(delimiter).append("AnnotatorNotes").append(delimiter).append('T').append(id).append(delimiter).append(translated).append(endLine);
        }
    }

    public static Sentence create(String param) {
        if (param == null) {
            return null;
        }
        if ((param = param.trim()).isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\[(([^\\s]+/[0-9a-zA-Z]+)\\s+)+?([^\\s]+/[0-9a-zA-Z]+)]/?[0-9a-zA-Z]+)|([^\\s]+/[0-9a-zA-Z]+)");
        Matcher matcher = pattern.matcher(param);
        LinkedList<IWord> wordList = new LinkedList<IWord>();
        while (matcher.find()) {
            String single = matcher.group();
            IWord word = WordFactory.create(single);
            if (word == null) {
                Predefine.logger.warning("\u5728\u7528 " + single + " \u6784\u9020\u5355\u8bcd\u65f6\u5931\u8d25\uff0c\u53e5\u5b50\u6784\u9020\u53c2\u6570\u4e3a " + param);
                return null;
            }
            wordList.add(word);
        }
        if (wordList.isEmpty()) {
            for (String w : param.split("\\s+")) {
                wordList.add(new Word(w, null));
            }
        }
        return new Sentence(wordList);
    }

    public int size() {
        return this.wordList.size();
    }

    public int length() {
        int length = 0;
        for (IWord word : this) {
            length += word.getValue().length();
        }
        return length;
    }

    public String text() {
        return this.text(null);
    }

    public String text(String delimiter) {
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder sb = new StringBuilder(this.size() * 3);
        for (IWord word : this) {
            if (word instanceof CompoundWord) {
                for (Word child : ((CompoundWord)word).innerList) {
                    sb.append(child.getValue()).append(delimiter);
                }
                continue;
            }
            sb.append(word.getValue()).append(delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }

    @Override
    public Iterator<IWord> iterator() {
        return this.wordList.iterator();
    }

    public List<IWord> findWordsByLabel(String label) {
        LinkedList<IWord> wordList = new LinkedList<IWord>();
        for (IWord word : this) {
            if (!label.equals(word.getLabel())) continue;
            wordList.add(word);
        }
        return wordList;
    }

    public IWord findFirstWordByLabel(String label) {
        for (IWord word : this) {
            if (!label.equals(word.getLabel())) continue;
            return word;
        }
        return null;
    }

    public ListIterator<IWord> findFirstWordIteratorByLabel(String label) {
        ListIterator<IWord> listIterator = this.wordList.listIterator();
        while (listIterator.hasNext()) {
            IWord word = listIterator.next();
            if (!label.equals(word.getLabel())) continue;
            return listIterator;
        }
        return null;
    }

    public boolean containsWordWithLabel(String label) {
        return this.findFirstWordByLabel(label) != null;
    }

    public List<Word> toSimpleWordList() {
        LinkedList<Word> wordList = new LinkedList<Word>();
        for (IWord word : this.wordList) {
            if (word instanceof CompoundWord) {
                wordList.addAll(((CompoundWord)word).innerList);
                continue;
            }
            wordList.add((Word)word);
        }
        return wordList;
    }

    public String[] toWordArray() {
        List<Word> wordList = this.toSimpleWordList();
        String[] wordArray = new String[wordList.size()];
        Iterator<Word> iterator = wordList.iterator();
        for (int i = 0; i < wordArray.length; ++i) {
            wordArray[i] = iterator.next().value;
        }
        return wordArray;
    }

    public String[][] toWordTagArray() {
        List<Word> wordList = this.toSimpleWordList();
        String[][] pair = new String[2][wordList.size()];
        Iterator<Word> iterator = wordList.iterator();
        for (int i = 0; i < pair[0].length; ++i) {
            Word word = iterator.next();
            pair[0][i] = word.value;
            pair[1][i] = word.label;
        }
        return pair;
    }

    public String[][] toWordTagNerArray(NERTagSet tagSet) {
        List<String[]> tupleList = Utility.convertSentenceToNER(this, tagSet);
        String[][] result = new String[3][tupleList.size()];
        Iterator<String[]> iterator = tupleList.iterator();
        for (int i = 0; i < result[0].length; ++i) {
            String[] tuple = iterator.next();
            for (int j = 0; j < 3; ++j) {
                result[j][i] = tuple[j];
            }
        }
        return result;
    }

    public Sentence mergeCompoundWords() {
        ListIterator<IWord> listIterator = this.wordList.listIterator();
        while (listIterator.hasNext()) {
            IWord word = listIterator.next();
            if (!(word instanceof CompoundWord)) continue;
            listIterator.set(new Word(word.getValue(), word.getLabel()));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sentence sentence = (Sentence)o;
        return this.toString().equals(sentence.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

