/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Viterbi;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.DynamicCustomDictionary;
import com.hankcs.hanlp.recognition.nr.JapanesePersonRecognition;
import com.hankcs.hanlp.recognition.nr.PersonRecognition;
import com.hankcs.hanlp.recognition.nr.TranslatedPersonRecognition;
import com.hankcs.hanlp.recognition.ns.PlaceRecognition;
import com.hankcs.hanlp.recognition.nt.OrganizationRecognition;
import com.hankcs.hanlp.seg.WordBasedSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class ViterbiSegment
extends WordBasedSegment {
    public ViterbiSegment() {
    }

    public ViterbiSegment(String customPath) {
        this.loadCustomDic(customPath, false);
    }

    public ViterbiSegment(String customPath, boolean cache) {
        this.loadCustomDic(customPath, cache);
    }

    public DoubleArrayTrie<CoreDictionary.Attribute> getDat() {
        return this.customDictionary.dat;
    }

    public void setDat(DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        this.customDictionary.dat = dat;
    }

    @Override
    protected List<Term> segSentence(char[] sentence) {
        WordNet wordNetAll = new WordNet(sentence);
        this.generateWordNet(wordNetAll);
        if (HanLP.Config.DEBUG) {
            System.out.printf("\u7c97\u5206\u8bcd\u7f51\uff1a\n%s\n", wordNetAll);
        }
        List<Vertex> vertexList = ViterbiSegment.viterbi(wordNetAll);
        if (this.config.useCustomDictionary) {
            if (this.config.indexMode > 0) {
                this.combineByCustomDictionary(vertexList, this.customDictionary.dat, wordNetAll);
            } else {
                this.combineByCustomDictionary(vertexList, this.customDictionary.dat);
            }
        }
        if (HanLP.Config.DEBUG) {
            System.out.println("\u7c97\u5206\u7ed3\u679c" + ViterbiSegment.convert(vertexList, false));
        }
        if (this.config.numberQuantifierRecognize) {
            this.mergeNumberQuantifier(vertexList, wordNetAll, this.config);
        }
        if (this.config.ner) {
            WordNet wordNetOptimum = new WordNet(sentence, vertexList);
            int preSize = wordNetOptimum.size();
            if (this.config.nameRecognize) {
                PersonRecognition.recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.translatedNameRecognize) {
                TranslatedPersonRecognition.recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.japaneseNameRecognize) {
                JapanesePersonRecognition.recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.placeRecognize) {
                PlaceRecognition.recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.organizationRecognize) {
                wordNetOptimum.clean();
                vertexList = ViterbiSegment.viterbi(wordNetOptimum);
                wordNetOptimum.clear();
                wordNetOptimum.addAll(vertexList);
                preSize = wordNetOptimum.size();
                OrganizationRecognition.recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (wordNetOptimum.size() != preSize) {
                vertexList = ViterbiSegment.viterbi(wordNetOptimum);
                if (HanLP.Config.DEBUG) {
                    System.out.printf("\u7ec6\u5206\u8bcd\u7f51\uff1a\n%s\n", wordNetOptimum);
                }
            }
        }
        if (this.config.indexMode > 0) {
            return this.decorateResultForIndexMode(vertexList, wordNetAll);
        }
        if (this.config.speechTagging) {
            ViterbiSegment.speechTagging(vertexList);
        }
        return ViterbiSegment.convert(vertexList, this.config.offset);
    }

    private static List<Vertex> viterbi(WordNet wordNet) {
        LinkedList<Vertex>[] nodes = wordNet.getVertexes();
        LinkedList<Vertex> vertexList = new LinkedList<Vertex>();
        for (Vertex node : nodes[1]) {
            node.updateFrom(nodes[0].getFirst());
        }
        for (int i = 1; i < nodes.length - 1; ++i) {
            LinkedList<Vertex> nodeArray = nodes[i];
            if (nodeArray == null) continue;
            for (Vertex node : nodeArray) {
                if (node.from == null) continue;
                for (Vertex to : nodes[i + node.realWord.length()]) {
                    to.updateFrom(node);
                }
            }
        }
        Vertex from = nodes[nodes.length - 1].getFirst();
        while (from != null) {
            vertexList.addFirst(from);
            from = from.from;
        }
        return vertexList;
    }

    private void loadCustomDic(String customPath, boolean isCache) {
        if (TextUtility.isBlank(customPath)) {
            return;
        }
        Predefine.logger.info("\u5f00\u59cb\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8bcd\u5178:" + customPath);
        DoubleArrayTrie<CoreDictionary.Attribute> dat = new DoubleArrayTrie<CoreDictionary.Attribute>();
        String[] path = customPath.split(";");
        String mainPath = path[0];
        StringBuilder combinePath = new StringBuilder();
        for (String aPath : path) {
            combinePath.append(aPath.trim());
        }
        File file = new File(mainPath);
        mainPath = file.getParent() + "/" + Math.abs(combinePath.toString().hashCode());
        if (DynamicCustomDictionary.loadMainDictionary(mainPath = mainPath.replace("\\", "/"), path, dat, isCache, this.config.normalization)) {
            this.customDictionary = new DynamicCustomDictionary(dat, null, null);
        }
    }
}

