/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.common;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CWSEvaluator {
    private int A_size;
    private int B_size;
    private int A_cap_B_size;
    private int OOV;
    private int OOV_R;
    private int IV;
    private int IV_R;
    private Set<String> dic;

    public CWSEvaluator() {
    }

    public CWSEvaluator(Set<String> dic) {
        this.dic = dic;
    }

    public CWSEvaluator(String dictPath) throws IOException {
        this(new TreeSet<String>());
        if (dictPath == null) {
            return;
        }
        try {
            IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(dictPath);
            for (String word : lineIterator) {
                if ((word = word.trim()).isEmpty()) continue;
                this.dic.add(word);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Result getResult(boolean percentage) {
        float p = (float)this.A_cap_B_size / (float)this.B_size;
        float r = (float)this.A_cap_B_size / (float)this.A_size;
        if (percentage) {
            p *= 100.0f;
            r *= 100.0f;
        }
        float oov_r = Float.NaN;
        if (this.OOV > 0) {
            oov_r = (float)this.OOV_R / (float)this.OOV;
            if (percentage) {
                oov_r *= 100.0f;
            }
        }
        float iv_r = Float.NaN;
        if (this.IV > 0) {
            iv_r = (float)this.IV_R / (float)this.IV;
            if (percentage) {
                iv_r *= 100.0f;
            }
        }
        return new Result(p, r, 2.0f * p * r / (p + r), oov_r, iv_r);
    }

    public Result getResult() {
        return this.getResult(true);
    }

    public void compare(String gold, String pred) {
        String[] wordArray = gold.split("\\s+");
        this.A_size += wordArray.length;
        String[] predArray = pred.split("\\s+");
        this.B_size += predArray.length;
        int goldIndex = 0;
        int predIndex = 0;
        int goldLen = 0;
        int predLen = 0;
        while (goldIndex < wordArray.length && predIndex < predArray.length) {
            if (goldLen == predLen) {
                if (wordArray[goldIndex].equals(predArray[predIndex])) {
                    if (this.dic != null) {
                        if (this.dic.contains(wordArray[goldIndex])) {
                            ++this.IV_R;
                        } else {
                            ++this.OOV_R;
                        }
                    }
                    ++this.A_cap_B_size;
                    goldLen += wordArray[goldIndex].length();
                    predLen += predArray[predIndex].length();
                    ++goldIndex;
                    ++predIndex;
                    continue;
                }
                goldLen += wordArray[goldIndex].length();
                predLen += predArray[predIndex].length();
                ++goldIndex;
                ++predIndex;
                continue;
            }
            if (goldLen < predLen) {
                goldLen += wordArray[goldIndex].length();
                ++goldIndex;
                continue;
            }
            predLen += predArray[predIndex].length();
            ++predIndex;
        }
        if (this.dic != null) {
            for (String word : wordArray) {
                if (this.dic.contains(word)) {
                    ++this.IV;
                    continue;
                }
                ++this.OOV;
            }
        }
    }

    public static Result evaluate(String goldFile, String predFile) throws IOException {
        return CWSEvaluator.evaluate(goldFile, predFile, null);
    }

    public static Result evaluate(Segment segment, String outputPath, String goldFile, String dictPath) throws IOException {
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(goldFile);
        BufferedWriter bw = IOUtil.newBufferedWriter(outputPath);
        for (String line : lineIterator) {
            List<Term> termList = segment.seg(line.replaceAll("\\s+", ""));
            int i = 0;
            for (Term term : termList) {
                bw.write(term.word);
                if (++i == termList.size()) continue;
                bw.write("  ");
            }
            bw.newLine();
        }
        bw.close();
        Result result = CWSEvaluator.evaluate(goldFile, outputPath, dictPath);
        return result;
    }

    public static Result evaluate(Segment segment, String testFile, String outputPath, String goldFile, String dictPath) throws IOException {
        return CWSEvaluator.evaluate(segment, outputPath, goldFile, dictPath);
    }

    public static Result evaluate(String goldFile, String predFile, String dictPath) throws IOException {
        IOUtil.LineIterator goldIter = new IOUtil.LineIterator(goldFile);
        IOUtil.LineIterator predIter = new IOUtil.LineIterator(predFile);
        CWSEvaluator evaluator = new CWSEvaluator(dictPath);
        while (goldIter.hasNext() && predIter.hasNext()) {
            evaluator.compare(goldIter.next(), predIter.next());
        }
        return evaluator.getResult();
    }

    public static class Result {
        public float P;
        public float R;
        public float F1;
        public float OOV_R;
        public float IV_R;

        public Result(float p, float r, float f1, float OOV_R, float IV_R) {
            this.P = p;
            this.R = r;
            this.F1 = f1;
            this.OOV_R = OOV_R;
            this.IV_R = IV_R;
        }

        public String toString() {
            return String.format("P:%.2f R:%.2f F1:%.2f OOV-R:%.2f IV-R:%.2f", Float.valueOf(this.P), Float.valueOf(this.R), Float.valueOf(this.F1), Float.valueOf(this.OOV_R), Float.valueOf(this.IV_R));
        }
    }
}

