/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

import java.util.ArrayList;
import java.util.List;
import org.collectd.api.DataSource;

public class DataSet {
    private String _type;
    private List<DataSource> _ds;

    private DataSet() {
        this._type = null;
        this._ds = new ArrayList<DataSource>();
    }

    public DataSet(String type) {
        this._type = type;
        this._ds = new ArrayList<DataSource>();
    }

    public DataSet(String type, DataSource dsrc) {
        this._type = type;
        this._ds = new ArrayList<DataSource>();
        this._ds.add(dsrc);
    }

    public DataSet(String type, List<DataSource> ds) {
        this._type = type;
        this._ds = ds;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void addDataSource(DataSource dsrc) {
        this._ds.add(dsrc);
    }

    public List<DataSource> getDataSources() {
        return this._ds;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._type);
        for (int i = 0; i < this._ds.size(); ++i) {
            if (i == 0) {
                sb.append("\t");
            } else {
                sb.append(", ");
            }
            sb.append(this._ds.get(i).toString());
        }
        return sb.toString();
    }

    public static DataSet parseDataSet(String str) {
        DataSource dsrc;
        int i;
        DataSet ds = new DataSet();
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        if (str.charAt(0) == '#') {
            return null;
        }
        String[] fields = str.split("\\s+");
        if (fields.length < 2) {
            return null;
        }
        ds._type = fields[0];
        for (i = 1; i < fields.length && (dsrc = DataSource.parseDataSource(fields[i])) != null; ++i) {
            ds._ds.add(dsrc);
        }
        if (i < fields.length) {
            return null;
        }
        return ds;
    }
}

