/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

public class DataSource {
    public static final int TYPE_COUNTER = 0;
    public static final int TYPE_GAUGE = 1;
    static final String COUNTER = "COUNTER";
    static final String GAUGE = "GAUGE";
    static final String NAN = "U";
    private static final String[] TYPES = new String[]{"COUNTER", "GAUGE"};
    String _name;
    int _type;
    double _min;
    double _max;

    public DataSource(String name, int type, double min, double max) {
        this._name = name;
        this._type = 1;
        if (type == 0) {
            this._type = 0;
        }
        this._min = min;
        this._max = max;
    }

    private DataSource() {
        this._type = 1;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double min) {
        this._min = min;
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double max) {
        this._max = max;
    }

    static double toDouble(String val) {
        if (val.equals(NAN)) {
            return Double.NaN;
        }
        return Double.parseDouble(val);
    }

    private String asString(double val) {
        if (Double.isNaN(val)) {
            return NAN;
        }
        return String.valueOf(val);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int DLM = 58;
        sb.append(this._name).append(':');
        sb.append(TYPES[this._type]).append(':');
        sb.append(this.asString(this._min)).append(':');
        sb.append(this.asString(this._max));
        return sb.toString();
    }

    public static DataSource parseDataSource(String str) {
        String[] fields;
        int str_len = str.length();
        DataSource dsrc = new DataSource();
        if (str.charAt(str_len - 1) == ',') {
            str = str.substring(0, str_len - 1);
        }
        if ((fields = str.split(":")).length != 4) {
            return null;
        }
        dsrc._name = fields[0];
        dsrc._type = fields[1].equals(GAUGE) ? 1 : 0;
        dsrc._min = DataSource.toDouble(fields[2]);
        dsrc._max = DataSource.toDouble(fields[3]);
        return dsrc;
    }
}

