/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

import org.collectd.api.PluginData;

public class Notification
extends PluginData {
    public static final int FAILURE = 1;
    public static final int WARNING = 2;
    public static final int OKAY = 4;
    public static String[] SEVERITY = new String[]{"FAILURE", "WARNING", "OKAY", "UNKNOWN"};
    private int _severity;
    private String _message;

    public Notification(PluginData pd) {
        super(pd);
    }

    public void setSeverity(int severity) {
        if (severity == 1 || severity == 2 || severity == 4) {
            this._severity = severity;
        }
    }

    public int getSeverity() {
        return this._severity;
    }

    public String getSeverityString() {
        switch (this._severity) {
            case 1: {
                return SEVERITY[0];
            }
            case 2: {
                return SEVERITY[1];
            }
            case 4: {
                return SEVERITY[2];
            }
        }
        return SEVERITY[3];
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public String getMessage() {
        return this._message;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" [").append(this.getSeverityString()).append("] ");
        sb.append(this._message);
        return sb.toString();
    }
}

