/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

import java.util.ArrayList;
import java.util.List;
import org.collectd.api.DataSource;
import org.collectd.api.PluginData;

public class ValueList
extends PluginData {
    List<Number> _values = new ArrayList<Number>();
    List<DataSource> _ds = new ArrayList<DataSource>();
    long _interval;

    public ValueList() {
    }

    public ValueList(PluginData pd) {
        super(pd);
    }

    public ValueList(ValueList vl) {
        this((PluginData)vl);
        this._interval = vl._interval;
        this._values.addAll(vl.getValues());
        this._ds.addAll(vl._ds);
    }

    public List<Number> getValues() {
        return this._values;
    }

    public void setValues(List<Number> values) {
        this._values = values;
    }

    public void addValue(Number value) {
        this._values.add(value);
    }

    public void clearValues() {
        this._values.clear();
    }

    public List<DataSource> getDataSource() {
        if (this._ds.size() > 0) {
            return this._ds;
        }
        return null;
    }

    public void setDataSource(List<DataSource> ds) {
        this._ds = ds;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("=[");
        List<DataSource> ds = this.getDataSource();
        int size = this._values.size();
        for (int i = 0; i < size; ++i) {
            Number val = this._values.get(i);
            String name = ds == null ? "unknown" + i : ds.get(i).getName();
            sb.append(name).append('=').append(val);
            if (i >= size - 1) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }
}

