/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public class CollectdMBean
implements DynamicMBean {
    private Map<String, Number> _metrics;

    public CollectdMBean(Map<String, Number> metrics) {
        this._metrics = metrics;
    }

    @Override
    public Object getAttribute(String key) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Number val = this._metrics.get(key);
        if (val == null) {
            throw new AttributeNotFoundException(key);
        }
        return val;
    }

    @Override
    public AttributeList getAttributes(String[] attrs) {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                result.add(new Attribute(attrs[i], this.getAttribute(attrs[i])));
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                continue;
            }
            catch (MBeanException mBeanException) {
                continue;
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return result;
    }

    protected String getAttributeType(String name) {
        return this._metrics.get(name).getClass().getName();
    }

    protected String getAttributeDescription(String name) {
        return name + " Attribute";
    }

    protected MBeanAttributeInfo[] getAttributeInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this._metrics.size()];
        int i = 0;
        for (String name : this._metrics.keySet()) {
            attrs[i++] = new MBeanAttributeInfo(name, this.getAttributeType(name), this.getAttributeDescription(name), true, false, false);
        }
        return attrs;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), CollectdMBean.class.getName(), this.getAttributeInfo(), null, null, null);
        return info;
    }

    @Override
    public Object invoke(String arg0, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList arg0) {
        return null;
    }
}

