/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.collectd.api.DataSource;
import org.collectd.api.PluginData;
import org.collectd.api.ValueList;
import org.collectd.mx.CollectdMBean;
import org.collectd.mx.CollectdMBeanRegistryMBean;
import org.collectd.mx.CollectdSummaryMBean;
import org.collectd.protocol.Dispatcher;
import org.collectd.protocol.Network;
import org.collectd.protocol.TypesDB;

public class CollectdMBeanRegistry
implements Dispatcher,
NotificationBroadcaster,
CollectdMBeanRegistryMBean {
    public static final String DOMAIN = "collectd";
    private Map<ObjectName, Map<String, Number>> beans = new HashMap<ObjectName, Map<String, Number>>();
    private NotificationBroadcasterSupport _broadcaster = new NotificationBroadcasterSupport();
    private static Pattern _hosts = CollectdMBeanRegistry.hostPattern();
    private long _notifSequence = 0L;
    private boolean _doSummary = !"false".equals(Network.getProperty("mx.summary"));
    MBeanServer bs = ManagementFactory.getPlatformMBeanServer();

    public void init() throws Exception {
        ObjectName name = new ObjectName("collectd:type=MBeanRegistry");
        this.bs.registerMBean(this, name);
    }

    private static Pattern hostPattern() {
        String hosts = Network.getProperty("mx.hosts");
        if (hosts == null) {
            return null;
        }
        return Pattern.compile(hosts);
    }

    private static boolean excludeHost(PluginData data) {
        if (_hosts == null) {
            return false;
        }
        return !_hosts.matcher(data.getHost()).find();
    }

    @Override
    public void dispatch(org.collectd.api.Notification notif) {
        if (CollectdMBeanRegistry.excludeHost(notif)) {
            return;
        }
        this._broadcaster.sendNotification(new Notification(notif.getSeverityString(), notif.getSource(), ++this._notifSequence, notif.getTime(), notif.getMessage()));
    }

    private String getRootName(String host, ValueList vl) {
        StringBuffer name = new StringBuffer();
        name.append(DOMAIN).append(':');
        if (host != null) {
            name.append("host=").append(host).append(',');
        }
        name.append("plugin=").append(vl.getPlugin());
        if (host == null) {
            name.append(",*");
        }
        return name.toString();
    }

    Map<String, Number> getMBean(ObjectName name) {
        return this.beans.get(name);
    }

    Number getMBeanAttribute(ObjectName name, String attribute) {
        Map<String, Number> bean = this.getMBean(name);
        if (bean == null) {
            return null;
        }
        return bean.get(attribute);
    }

    private Map<String, Number> getMBean(ValueList vl) {
        ObjectName name;
        String instance = vl.getPluginInstance();
        StringBuffer bname = new StringBuffer();
        bname.append(this.getRootName(vl.getHost(), vl));
        if (!vl.defined(instance)) {
            List<DataSource> ds = vl.getDataSource();
            if (ds == null) {
                ds = TypesDB.getInstance().getType(vl.getType());
            }
            if (ds != null && ds.size() > 1) {
                instance = vl.getTypeInstance();
            }
        }
        if (vl.defined(instance)) {
            bname.append(',').append("name=").append(instance);
        }
        try {
            name = new ObjectName(bname.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(bname + ": " + e);
        }
        Map<String, Number> metrics = this.getMBean(name);
        if (metrics != null) {
            return metrics;
        }
        metrics = new HashMap<String, Number>();
        this.beans.put(name, metrics);
        try {
            ObjectName sname;
            this.bs.registerMBean(new CollectdMBean(metrics), name);
            if (this._doSummary && !this.bs.isRegistered(sname = new ObjectName(this.getRootName("__summary__", vl)))) {
                ObjectName query = new ObjectName(this.getRootName(null, vl));
                CollectdSummaryMBean summary = new CollectdSummaryMBean(query, metrics);
                summary.setMBeanRegistry(this);
                this.bs.registerMBean(summary, sname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metrics;
    }

    @Override
    public void dispatch(ValueList vl) {
        if (CollectdMBeanRegistry.excludeHost(vl)) {
            return;
        }
        String type = vl.getType();
        List<Number> values = vl.getValues();
        int size = values.size();
        Map<String, Number> metrics = this.getMBean(vl);
        if (size == 1) {
            String ti = vl.getTypeInstance();
            String key = vl.defined(ti) ? type + "." + ti : type;
            metrics.put(key, values.get(0));
        } else {
            List<DataSource> ds = vl.getDataSource();
            if (ds == null) {
                ds = TypesDB.getInstance().getType(vl.getType());
            }
            for (int i = 0; i < size; ++i) {
                String key = ds != null ? type + "." + ds.get(i).getName() : type + ".unknown" + i;
                metrics.put(key, values.get(i));
            }
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this._broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(org.collectd.api.Notification.SEVERITY, Notification.class.getName(), "Collectd Notifications")};
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this._broadcaster.removeNotificationListener(listener);
    }
}

