/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.collectd.mx.CollectdMBean;
import org.collectd.mx.CollectdMBeanRegistry;

public class CollectdSummaryMBean
extends CollectdMBean {
    private ObjectName _query;
    private CollectdMBeanRegistry _registry;

    public CollectdSummaryMBean(ObjectName name, Map<String, Number> metrics) {
        super(metrics);
        this._query = name;
    }

    void setMBeanRegistry(CollectdMBeanRegistry registry) {
        this._registry = registry;
    }

    private Object getAverage(String key) {
        double sum = 0.0;
        int num = 0;
        Set<ObjectName> names = this._registry.bs.queryNames(this._query, null);
        for (ObjectName name : names) {
            Number val = this._registry.getMBeanAttribute(name, key);
            if (val == null) continue;
            ++num;
            sum += val.doubleValue();
        }
        double avg = num == 0 ? 0.0 : sum / (double)num;
        return new Double(avg);
    }

    @Override
    public Object getAttribute(String key) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.getAverage(key);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String getAttributeType(String name) {
        return Double.class.getName();
    }

    @Override
    protected String getAttributeDescription(String name) {
        return super.getAttributeDescription(name) + " (summary)";
    }
}

