/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.mx;

import java.util.List;
import org.collectd.api.DataSource;
import org.collectd.protocol.TypesDB;

public class MBeanAttribute {
    private static final TypesDB _types = TypesDB.getInstance();
    private String _name;
    private String _attributeName;
    private String _compositeKey;
    private String _typeName;
    private int _dataType;

    public MBeanAttribute(String attributeName) {
        this(attributeName, 1);
    }

    public MBeanAttribute(String attributeName, int dataType) {
        this(attributeName, dataType, null);
    }

    private static final int getDataType(String typeName) {
        List<DataSource> ds = _types.getType(typeName);
        if (ds == null || ds.size() == 0) {
            return 1;
        }
        return ds.get(0).getType();
    }

    public MBeanAttribute(String attributeName, String typeName) {
        this(attributeName, MBeanAttribute.getDataType(typeName), typeName);
    }

    public MBeanAttribute(String attributeName, int dataType, String typeName) {
        int ix;
        this._name = attributeName;
        this._dataType = dataType;
        this._typeName = typeName;
        if (this._typeName == null) {
            this._typeName = dataType == 0 ? "counter" : "gauge";
        }
        if ((ix = attributeName.indexOf(46)) != -1) {
            this._attributeName = attributeName.substring(0, ix);
            this._compositeKey = attributeName.substring(ix + 1);
        } else {
            this._attributeName = attributeName;
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public void setAttributeName(String attributeName) {
        this._attributeName = attributeName;
    }

    public String getCompositeKey() {
        return this._compositeKey;
    }

    public void setCompositeKey(String compositeKey) {
        this._compositeKey = compositeKey;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    public int getDataType() {
        return this._dataType;
    }

    public void setDataType(int dataType) {
        this._dataType = dataType;
    }
}

